// src/shared/sections/profile/password/components/password-strength-indicator.tsx
import React from 'react';
import { Box, Typography, LinearProgress } from '@mui/material';

interface PasswordStrengthIndicatorProps {
  password: string;
}

const calculatePasswordStrength = (password: string): number => {
  let strength = 0;
  if (password.length >= 8) strength += 20;
  if (password.match(/[a-z]+/)) strength += 20;
  if (password.match(/[A-Z]+/)) strength += 20;
  if (password.match(/[0-9]+/)) strength += 20;
  if (password.match(/[@#$&!]+/)) strength += 20;
  return strength;
};

const getPasswordStrengthColor = (strength: number): string => {
  if (strength <= 20) return '#f44336';
  if (strength <= 40) return '#ff9800';
  if (strength <= 60) return '#ffeb3b';
  if (strength <= 80) return '#8bc34a';
  return '#4caf50';
};

const getPasswordStrengthLabel = (strength: number): string => {
  if (strength <= 20) return 'Très faible';
  if (strength <= 40) return 'Faible';
  if (strength <= 60) return 'Moyen';
  if (strength <= 80) return 'Fort';
  return 'Très fort';
};

export default function PasswordStrengthIndicator({ password }: PasswordStrengthIndicatorProps) {
  const strength = calculatePasswordStrength(password);
  
  return (
    <Box sx={{ mt: 1 }}>
      <Box sx={{ display: 'flex', justifyContent: 'space-between', mb: 0.5 }}>
        <Typography variant="caption" color="textSecondary">
          Force du mot de passe:
        </Typography>
        <Typography variant="caption" sx={{ color: getPasswordStrengthColor(strength) }}>
          {getPasswordStrengthLabel(strength)}
        </Typography>
      </Box>
      <LinearProgress
        variant="determinate"
        value={strength}
        sx={{
          height: 4,
          borderRadius: 2,
          bgcolor: 'grey.200',
          '& .MuiLinearProgress-bar': {
            bgcolor: getPasswordStrengthColor(strength),
          },
        }}
      />
    </Box>
  );
}