// src/shared/sections/profile/password/utils/password-validation.ts
import * as yup from 'yup';

export const passwordValidationSchema = yup.object().shape({
  currentPassword: yup.string().required('Le mot de passe actuel est requis'),
  newPassword: yup.string()
    .min(8, 'Le mot de passe doit contenir au moins 8 caractères')
    .matches(/[A-Z]/, 'Le mot de passe doit contenir au moins une majuscule')
    .matches(/[a-z]/, 'Le mot de passe doit contenir au moins une minuscule')
    .matches(/[0-9]/, 'Le mot de passe doit contenir au moins un chiffre')
    .matches(/[@#$&!]/, 'Le mot de passe doit contenir au moins un caractère spécial (@#$&!)')
    .required('Le nouveau mot de passe est requis'),
  confirmPassword: yup.string()
    .oneOf([yup.ref('newPassword')], 'Les mots de passe ne correspondent pas')
    .required('La confirmation du mot de passe est requise'),
});
export const resetValidationSchemas = {
    code: yup.object({
      code: yup.string()
        .required('Le code est requis')
        .min(6, 'Le code doit contenir 6 caractères')
        .max(6, 'Le code doit contenir 6 caractères'),
    }),
    newPassword: yup.object({
      newPassword: yup.string()
        .min(8, 'Le mot de passe doit contenir au moins 8 caractères')
        .matches(/[A-Z]/, 'Le mot de passe doit contenir au moins une majuscule')
        .matches(/[a-z]/, 'Le mot de passe doit contenir au moins une minuscule')
        .matches(/[0-9]/, 'Le mot de passe doit contenir au moins un chiffre')
        .matches(/[@#$&!]/, 'Le mot de passe doit contenir au moins un caractère spécial (@#$&!)')
        .required('Le nouveau mot de passe est requis'),
      confirmPassword: yup.string()
        .oneOf([yup.ref('newPassword')], 'Les mots de passe ne correspondent pas')
        .required('La confirmation du mot de passe est requise'),
    }),
  };