import React, { useState } from 'react';
import {
    Box,
    Typography,
    FormControl,
    RadioGroup,
    FormControlLabel,
    Radio,
    Grid,
    Select,
    MenuItem,
    InputLabel,
    Checkbox,
    FormGroup,
    Paper,
    Avatar
} from '@mui/material';
import KeyboardArrowDownIcon from '@mui/icons-material/KeyboardArrowDown';
import HomeIcon from '@mui/icons-material/Home';
import DoDisturbIcon from '@mui/icons-material/DoDisturb';
import PersonOffIcon from '@mui/icons-material/PersonOff';
import CommuteIcon from '@mui/icons-material/Commute';
import SickIcon from '@mui/icons-material/Sick';
import FamilyRestroomIcon from '@mui/icons-material/FamilyRestroom';
import BeachAccessIcon from '@mui/icons-material/BeachAccess';

const WorkStatusComponent = () => {
    const [status, setStatus] = useState('bureau');

    return (
        <Paper sx={{ p: 4, borderRadius: 1 }}>
            <Box sx={{ display: 'flex', alignItems: 'center' }}>
                <Typography variant="h4" component="h1" sx={{ fontWeight: 500 }}>
                    Statut de travail
                </Typography>
            </Box>
            <Typography variant="body1" sx={{ mb: 3, color: 'text.secondary' }}>
                Informez tout le monde de votre statut
            </Typography>

            <FormControl component="fieldset" fullWidth>
                <Grid container spacing={4}>
                    <Grid item xs={12} md={4}>
                        <RadioGroup
                            value={status}
                            onChange={(e) => setStatus(e.target.value)}
                        >
                            <FormControlLabel
                                value="bureau"
                                control={<Radio color="primary" />}
                                label={
                                    <Box sx={{ display: 'flex', alignItems: 'center' }}>
                                        Au bureau
                                    </Box>
                                }
                                sx={{ mb: 2 }}
                            />
                            <FormControlLabel
                                value="absent"
                                control={<Radio />}
                                label={
                                    <Box sx={{ display: 'flex', alignItems: 'center' }}>
                                        Absent(e) du bureau
                                        <Avatar sx={{ ml: 1, width: 24, height: 24, bgcolor: '#303030' }}>
                                            <PersonOffIcon sx={{ fontSize: 16 }} />
                                        </Avatar>
                                    </Box>
                                }
                                sx={{ mb: 2 }}
                            />
                            <FormControlLabel
                                value="ne_pas_deranger"
                                control={<Radio />}
                                label={
                                    <Box sx={{ display: 'flex', alignItems: 'center' }}>
                                        Ne pas déranger
                                        <Avatar sx={{ ml: 1, width: 24, height: 24, bgcolor: '#303030' }}>
                                            <DoDisturbIcon sx={{ fontSize: 16 }} />
                                        </Avatar>
                                    </Box>
                                }
                            />
                        </RadioGroup>
                    </Grid>

                    <Grid item xs={12} md={4}>
                        <RadioGroup>
                            <FormControlLabel
                                value="domicile"
                                control={<Radio />}
                                label={
                                    <Box sx={{ display: 'flex', alignItems: 'center' }}>
                                        Travail à domicile
                                        <Avatar sx={{ ml: 1, width: 24, height: 24, bgcolor: '#303030' }}>
                                            <HomeIcon sx={{ fontSize: 16 }} />
                                        </Avatar>
                                    </Box>
                                }
                                sx={{ mb: 2 }}
                            />
                            <FormControlLabel
                                value="hors_bureau"
                                control={<Radio />}
                                label={
                                    <Box sx={{ display: 'flex', alignItems: 'center' }}>
                                        Travail hors du bureau
                                        <Avatar sx={{ ml: 1, width: 24, height: 24, bgcolor: '#303030' }}>
                                            <CommuteIcon sx={{ fontSize: 16 }} />
                                        </Avatar>
                                    </Box>
                                }
                            />
                        </RadioGroup>
                    </Grid>

                    <Grid item xs={12} md={4}>
                        <RadioGroup>
                            <FormControlLabel
                                value="conge_maladie"
                                control={<Radio />}
                                label={
                                    <Box sx={{ display: 'flex', alignItems: 'center' }}>
                                        En congé maladie
                                        <Avatar sx={{ ml: 1, width: 24, height: 24, bgcolor: '#303030' }}>
                                            <SickIcon sx={{ fontSize: 16 }} />
                                        </Avatar>
                                    </Box>
                                }
                                sx={{ mb: 2 }}
                            />
                            <FormControlLabel
                                value="en_famille"
                                control={<Radio />}
                                label={
                                    <Box sx={{ display: 'flex', alignItems: 'center' }}>
                                        En famille
                                        <Avatar sx={{ ml: 1, width: 24, height: 24, bgcolor: '#303030' }}>
                                            <FamilyRestroomIcon sx={{ fontSize: 16 }} />
                                        </Avatar>
                                    </Box>
                                }
                                sx={{ mb: 2 }}
                            />
                            <FormControlLabel
                                value="en_conge"
                                control={<Radio />}
                                label={
                                    <Box sx={{ display: 'flex', alignItems: 'center' }}>
                                        En congé
                                        <Avatar sx={{ ml: 1, width: 24, height: 24, bgcolor: '#303030' }}>
                                            <BeachAccessIcon sx={{ fontSize: 16 }} />
                                        </Avatar>
                                    </Box>
                                }
                            />
                        </RadioGroup>
                    </Grid>
                </Grid>
            </FormControl>

            <Box sx={{ mt: 3, mb: 3 }}>
                <FormControl fullWidth variant="outlined" sx={{ bgcolor: '#f5f5f5', borderRadius: 1 }}>
                    <Select
                        displayEmpty
                        value=""
                        IconComponent={KeyboardArrowDownIcon}
                        renderValue={() => "Choisir les dates (facultatif)"}
                        sx={{
                            '& .MuiOutlinedInput-notchedOutline': { border: 'none' },
                            color: 'text.secondary'
                        }}
                    >
                        <MenuItem value="">Choisir les dates</MenuItem>
                        <MenuItem value="today">{"Aujourd'hui"}</MenuItem>
                        <MenuItem value="tomorrow">Demain</MenuItem>
                        <MenuItem value="week">Cette semaine</MenuItem>
                    </Select>
                </FormControl>
            </Box>

            <FormGroup>
                <FormControlLabel
                    control={<Checkbox />}
                    label="Désactiver les notifications par e-mail et par mobile pendant votre absence du bureau"
                />
            </FormGroup>

            <Box sx={{ mt: 3, mb: 2 }}>
                <Typography variant="body1" sx={{ fontWeight: 500, color: 'text.primary' }}>
                    {"Indication de l'activité de l'utilisateur"}
                </Typography>
            </Box>

            <FormGroup>
                <FormControlLabel
                    control={<Checkbox />}
                    label="Désactivez l'option en ligne (vous ne verrez pas non plus si d'autres personnes sont en ligne)"
                />
            </FormGroup>
        </Paper>
    );
};

export default WorkStatusComponent;