
import { Box, Stack, TableContainer, Typography } from '@mui/material';
import { styled } from '@mui/material/styles';
import FontAwesome from '@/shared/components/fontawesome';
import { HEADER } from '@/layouts/config-layout';

export const StyledIcon = styled(FontAwesome)(({ theme }) => ({
  width: 20,
  height: 20,
  marginRight: theme.spacing(2),
  color: theme.palette.primary.main,
}));

export const InfoItem = ({ icon, label, value }: { icon: any; label: string; value: string }) => (
  <Stack direction="row" alignItems="center" sx={{ mb: 2.5 }}>
    <StyledIcon icon={icon} />
    <Box>
      <Typography variant="caption" sx={{ color: 'text.secondary', display: 'block', mb: 0.5 }}>
        {label}
      </Typography>
      <Typography variant="body2">{value}</Typography>
    </Box>
  </Stack>
);

export const StatusBadge = styled(Box)(({ theme, status }: { theme: any; status: string }) => ({
  padding: theme.spacing(0.5, 1.5),
  borderRadius: theme.shape.borderRadius,
  textAlign: 'center',
  backgroundColor: 
    status === 'active' ? theme.palette.success.lighter :
    status === 'pending' ? theme.palette.warning.lighter :
    theme.palette.error.lighter,
  color: 
    status === 'active' ? theme.palette.success.darker :
    status === 'pending' ? theme.palette.warning.darker :
    theme.palette.error.darker,
  width: 'fit-content'
}));
export const StyledTableContainer = styled(TableContainer)(({ theme }) => ({
  borderRadius: theme.shape.borderRadius,
  boxShadow: 'none',
  border: `1px solid ${theme.palette.divider}`,
  height: `calc(100vh - ${HEADER.H_DESKTOP + 195}px)`,
  overflow: 'auto',
  '& .MuiTableCell-head': {
    backgroundColor: theme.palette.background.neutral,
    color: theme.palette.text.secondary,
    fontWeight: 600,
  },
  '& .MuiTableRow-root:hover': {
    backgroundColor: theme.palette.action.hover,
  },
}));

export const InfoBox = styled(Box)(({ theme }) => ({
  backgroundColor: theme.palette.info.lighter,
  borderRadius: theme.shape.borderRadius,
  padding: theme.spacing(2),
  marginBottom: theme.spacing(3),
  display: 'flex',
  alignItems: 'center',
  gap: theme.spacing(2),

}));
