import theme from '@/shared/theme';
import { Box, Chip } from '@mui/material';
import { alpha, styled } from '@mui/system';

export const StatusChip = styled(Chip)(({ status, theme }: { status: string; theme: any }) => ({
  '&.MuiChip-root': {
    fontWeight: 500,
    borderRadius: '8px',
    padding: '9px 0',
    height: '100%',
    width: '100%',
  
    ...(status === 'En attente' && {
      backgroundColor: '#FEF8E7',  
      color: '#F9B90B',  
    }),
    ...((status === 'Approuvée' || status === 'Validée') && {
      backgroundColor: '#E9FBF0',
      color: '#36B37E',
    }),
    ...((status === 'Refusé' || status === 'Refusée') && {
      backgroundColor: '#FFE1E1', 
      color: '#FF3434',
    }),
  },
}));

export const getStatusColor = (status: string) => {
  switch (status) {
    case 'Approuvée':
    case 'Validée':
      return '#36B37E';  
    case 'Refusé':
    case 'Refusée':
      return '#FF3434'; 
    case 'En attente':
      return '#F9B90B';  
    default:
      return '#81919A'; 
  }
};
export const StyledHeaderContainer = styled(Box)({
  display: 'grid',
  gridTemplateColumns: '50% 25% 25%',
  width: '100%',
  alignItems: 'center',
  gap: '16px',
  '& .MuiSelect-select': {
    minWidth: '180px',
  }
});

export const StyledGridContainer = styled(Box)({
  display: 'grid',
  gridTemplateColumns: '50% 25% 25%',
  width: '100%',
  alignItems: 'start',
  gap: '16px',
  '& .checkbox-column': {
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    height: '100%',
    '& .MuiCheckbox-root': {
      padding: '12px',
      margin: '0 auto',
    }
  }
})