export type AppointmentStatus = 'prevu' | 'termine' | 'annule' ;

export interface IMedicalCenter {
  id: string;
  name: string;
  address: string;
}

export interface IDoctor {
  id: string;
  name: string;
  medicalCenterId: string;
}
export type AppointmentType = 
  | 'Visite Médicale (médecine du travail)' 
  | 'Visite Médicale (Préfectorale)' 
  | 'Entretien Annuel' 
  | 'Formation' 
  | 'Autre' 
export interface IAppointment {
  id: string;
  driverId: string;
  driverName: string;
  doctorId: string;
  doctorName: string;
  medicalCenterId: string;
  medicalCenterName: string;
  date: string;
  time: string;
  status: AppointmentStatus;
  type: AppointmentType;
  otherType?: string;
  reportUrl?: string;
  comments: string;
  createdAt: string;
  updatedAt: string;
}

export interface IMedicalReport {
  id: string;
  appointmentId: string;
  url: string;
  isValidated: boolean;
  validatedBy?: string;
  validatedAt?: string;
  comments?: string;
}