export interface IBesoinRecrutement {
  id: string;
  demandeur: string;
  motif: string;
  nombrePostes: number;
  departement: string;
  circuit: string;
  statut: BesoinRecrutementStatut;
  dateCreation: string;
  observation?: string;
  candidatureAssocieeId?: string;
}

export enum BesoinRecrutementStatut {
  EnAttente = 'enAttente',
  EnCours = 'enCours',
  Traite = 'traite'
}

export enum BesoinRecrutementTab {
  Tous = 'tous',
  EnAttente = 'enAttente',
  EnCours = 'enCours',
  Traites = 'traites'
}

export const INITIAL_BESOIN_RECRUTEMENT_DATA: IBesoinRecrutement = {
  id: '',
  demandeur: '',
  motif: '',
  nombrePostes: 1,
  departement: '',
  circuit: '',
  statut: BesoinRecrutementStatut.EnAttente,
  dateCreation: new Date().toISOString().split('T')[0]
}; 