export type IChauffeur = {
    id: string;
    numeroChauffeur: string;
    trajet: Interval;
    horaires: Interval;
    dateDebut: string;
    dateFin: string;
    chauffeur: string;
    joursAttribues: JoursAttribues;
    observation: string;
  }

  export type Interval  = {
    depart: string;
    arriver: string;
  };

  export type DayPeriod = {
    matin: boolean;
    soir: boolean;
  };
  
  export type WeekDays = {
    lundi: DayPeriod;
    mardi: DayPeriod;
    mercredi: DayPeriod;
    jeudi: DayPeriod;
    vendredi: DayPeriod;
    samedi: DayPeriod;
    dimanche: DayPeriod;
  };
  
  export type JoursAttribues = {
    pair: WeekDays;
    impair: WeekDays;
  };