
export type IContrat = {
  id: string;
  dateMarche: string;
  dateRenouvellement: string;
  dateFin: string;
  codeContrat: string;
  intitule: string;
  client: string;
  societe: string;
  agence: string;
  numeroMarche: string;
  numeroLot: string;
  status: string;
  isActive: boolean;
  dateDebut?: string;
  grillePrix?: string;
  dateRevisionPrix?: string;
  frequence?: string;
  numeroEngagement?: string;
  dureeMarche?: string;
  reconduction?: 'oui' | 'non';
  typeContratTAD?: 'oui' | 'non';
  observation?: string;
  description?: string;
  color?: string;
};

export type IContratTableFilters = {
  intitule: string;
  client: string;
  codeContrat: string;
};



//**************************************************
export type ContractList = {
  id: string;
  title: string;
  contractCode: string;
  endDate: string;
  marketDate: string;
  renewalDate: string;
  marketNumber: string;
  agencyId: number;
  agencyName: string;
  departmentId: number;
  departmentName: string;
  lotId: number;
  lotNumber: string;
  status: ContractStatus;
  contractColor: string;
  active: boolean;
};

export type Contract = {
  id: string;
  title: string;
  contractCode: string;
  startDate: string;
  endDate: string;
  marketDate: string;
  renewalDate: string;
  priceRevisionDate: string;
  marketNumber: string;
  status: ContractStatus;
  pricingGridType: number;
  priceRevisionFrequencyMonths: number;
  contractColor: string;
  commitmentNumber: string;
  contractDurationMonths: number;
  renewalStatus: boolean;
  tadType: boolean;
  googleTADVisibility: boolean;
  circuits: CircuitWithSpecificInfo[];
  documentIds: string[];
  agencyId: number;
  agencyName: string;
  departmentId: number;
  departmentName: string;
  lotId: number;
  lotNumber: string;
  observation: string;
  active: boolean;
};

export enum ContractStatus {
  NEW = 'NEW',
  IN_PROGRESS = 'IN_PROGRESS',
  COMPLETED = 'COMPLETED',
  CANCELLED = 'CANCELLED'
}

export const contractStatusLabelsFr: Record<ContractStatus, string> = {
  [ContractStatus.NEW]: 'Nouveau',
  [ContractStatus.IN_PROGRESS]: 'En cours',
  [ContractStatus.COMPLETED]: 'Terminé',
  [ContractStatus.CANCELLED]: 'Résilié',
};

export const CONTRACT_STATUS = [
  { value: ContractStatus.NEW, label: "Nouveau" },
  { value: ContractStatus.IN_PROGRESS, label: "En cours" },
  { value: ContractStatus.COMPLETED, label: "Terminé" },
  { value: ContractStatus.CANCELLED, label: "Résilié" },
];

export const getContractStatusLabelFr = (status: ContractStatus): string => {
  return contractStatusLabelsFr[status] ?? status;
};

export type CircuitWithSpecificInfo = {
  id: string;
  circuitCode: string;
  titled: string;
};


export interface ContractPageFilterParams {
  id?: number;
  contractCode?: string;
  title?: string;
  endDate?: string;
  marketDate?: string;
  renewalDate?: string;
  marketNumber?: string;
  agencyName?: string;
  departmentName?: string;
  lotNumber?: string;
  status?: string;
  contractColor?: string;
  page?: number;
  size?: number;
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
}

export type ContractRequest = {
  id: string;
  title: string;
  contractCode: string;
  startDate: string;
  endDate: string;
  marketDate: string;
  renewalDate: string;
  priceRevisionDate: string;
  marketNumber: string;
  status: ContractStatus;
  pricingGridType: number;
  priceRevisionFrequencyMonths: number;
  contractColor: string;
  commitmentNumber: string;
  contractDurationMonths: number;
  renewalStatus: string;
  tadType: string;
  agencyId: number;
  departmentId: number;
  lotId: number;
  observation: string;
};

export const mapContractToRequest = (contract: Contract): ContractRequest => {
  return {
    id: contract.id,
    title: contract.title,
    contractCode: contract.contractCode,
    startDate: contract.startDate,
    endDate: contract.endDate,
    marketDate: contract.marketDate,
    renewalDate: contract.renewalDate,
    priceRevisionDate: contract.priceRevisionDate,
    marketNumber: contract.marketNumber,
    status: contract.status,
    pricingGridType: contract.pricingGridType,
    priceRevisionFrequencyMonths: contract.priceRevisionFrequencyMonths,
    contractColor: contract.contractColor,
    commitmentNumber: contract.commitmentNumber,
    contractDurationMonths: contract.contractDurationMonths,
    renewalStatus: contract.renewalStatus.toString(),
    tadType: contract.tadType.toString(),
    agencyId: contract.agencyId,
    departmentId: contract.departmentId,
    lotId: contract.lotId,
    observation: contract.observation || '',
  };
};
