export enum PeriodType {
    Matin = 'MATIN',
    Midi = 'MIDI',
    ApresMidi = 'APRES_MIDI',
    Soir = 'SOIR',
  }
 
  export type DriverRoute = {
    id: number;
    type: PeriodType;
    startHour: Date;
    endHour: Date;
    description: string;
  };
  
  export type MileageInterval = {
    id: number;
    startMileage: number;
    endMileage: number;
  };
  
  export type WorkedDay = {
    id: number;
    date: Date;
    fuelAmount: number;
    observation: string;
    driverRouteList: DriverRoute[];
    mileageIntervall: MileageInterval;
  };
  
    export type DriverRouteSheet = {
      id: number;
      date: Date;
      name: string;
      isSubmitted: boolean;
      workedDays: WorkedDay[];
    };
  export  interface IRoadMapMileage {
  startMileage: number | undefined;
  endMileage: number | undefined;
  fuelAmount: number | undefined;
}


export interface MileageIntervalDTO {
  startMileage: number;
  endMileage: number;
}

export interface RoadDTO {
  startHour: string;
  endHour: string;
  type: string;
}

export interface OtherTripDTO {
  startHour: string;
  endHour: string;
  type: string;
}

export interface WorkedDayDTO {
  driverRoadMapId: number;
  date: string;
  fuelAmount: number;
  observation: string;
  mileageIntervall: MileageIntervalDTO;
  roads: RoadDTO[];
  otherTrips: OtherTripDTO[];
}

export interface AddressDTO {
  street?: string;
  city?: string;
  zipCode?: string;
}

export interface DriverInfoDTO {
  id: number;
  firstName: string;
  lastName: string;
  vehiculeRegistration: string | null;
  departmentName: string | null;
  fuelCardNumber: string | null;
  drivingLicenseName: string | null;
  addresses: AddressDTO[];
}

