import type { TableColumn } from "@/shared/types/common"

export enum EmailStatus {
  ENVOYE = "ENVOYE",
  ECHEC = "ECHEC",
  PLANIFIE = "PLANIFIE",
}

export interface IEmailHistory {
  id: string
  templateId: string
  templateTitre: string
  dateEnvoi: string
  destinataires: string
  status: EmailStatus
  details?: string
  logsErreur?: string
}

export interface IEmailHistoryFilter {
  templateTitre?: string
  dateDebut?: Date
  dateFin?: Date
  status?: EmailStatus[]
}

export const DEFAULT_EMAIL_HISTORY_TABLE_HEAD: TableColumn[] = [
  { id: "templateTitre", label: "Titre du modèle", type: "text" },
  { id: "dateEnvoi", label: "Date d'envoi", type: "datetime" },
  { id: "destinataires", label: "Destinataires", type: "text" },
  { id: "status", label: "Statut d'envoi", type: "text" },
]
