import type { TableColumn } from "@/shared/types/common"

export enum EmailTemplateCategory {
  NOTIFICATION_RH = "NOTIFICATION_RH",
  COMMUNICATION_INTERNE = "COMMUNICATION_INTERNE",
  RAPPEL = "RAPPEL",
  INFORMATION = "INFORMATION",
  AUTRE = "AUTRE",
}

export interface IEmailTemplate {
  id: string
  titre: string
  description: string
  categorie: EmailTemplateCategory
  contenu: string
  dateCreation: string
  isArchive: boolean
}

export interface IEmailTemplateFilter {
  titre?: string
  categorie?: EmailTemplateCategory[]
  dateDebut?: Date
  dateFin?: Date
}

export const INITIAL_EMAIL_TEMPLATE_DATA: IEmailTemplate = {
  id: "",
  titre: "",
  description: "",
  categorie: EmailTemplateCategory.AUTRE,
  contenu: "",
  dateCreation: new Date().toISOString().split("T")[0],
  isArchive: false,
}

export const DEFAULT_EMAIL_TEMPLATE_TABLE_HEAD: TableColumn[] = [
  { id: "titre", label: "Titre", type: "text" },
  { id: "description", label: "Description", type: "text" },
  { id: "categorie", label: "Catégorie", type: "text" },
  { id: "dateCreation", label: "Date de création", type: "date"}
]
