export enum EmailStatus {
  ENVOYE = "ENVOYE",
  EN_ATTENTE = "EN_ATTENTE",
  ECHEC = "ECHEC",
}

export interface IEmail {
  id: string
  dateHeure: string
  destinataire: string
  destinataireEmail: string
  objet: string
  contenu: string
  status: EmailStatus
  pieceJointes?: IEmailAttachment[]
  logsErreur?: string
}

export interface IEmailAttachment {
  id: string
  nom: string
  taille: string
  type: string
  url: string
}

export interface IEmailFilter {
  dateDebut?: Date
  dateFin?: Date
  status?: EmailStatus[]
  recherche?: string
}

export const INITIAL_EMAIL_DATA: IEmail = {
  id: "",
  dateHeure: new Date().toISOString(),
  destinataire: "",
  destinataireEmail: "",
  objet: "",
  contenu: "",
  status: EmailStatus.EN_ATTENTE,
}

export enum EmailManagementTab {
  Templates = "templates",
  Automations = "automations",
  History = "history",
}

