import { Dayjs } from "dayjs";
import { JoursAttribues } from "./chauffeur";
import { Departements } from "./etablissement";
import { AddressData } from "./common";
import { Civility } from "./common";

export type IUsager = {
    id: string; 
    civilite?: string;
    nom: string; 
    prenom: string; 
    dateNaissance: string;
    lieuNaissance: string; 
    etablissement: string; 
    classe: string; 
    adresse: string; 
    etat: string;
    avenantDu: string;
    code: string;
    type: string;
    responsibleName: string;
    email: string;
    tel: string;
    mobile: string;
    entreeLe: string;
    department:Departements;
    observation: string;
    isActive:boolean;
    specificite?: string;
    joursOuverture?: string;
    ParticulariteTransport?: string;
    categorie?: string;
    enseig?: string;
  };
  export enum RelationType {
    MERE = "mere",
    PERE = "pere",
    GRANDS_PARENTS = "grands_parents",
    FOYER_DE_VIE = "foyer_de_vie",
    ETABLISSEMENT_MEDICAL = "etablissement_medical",
    AUTRE = "autre"
  }

export interface PhoneNumber {
  id: string;
  number: string;
  type: 'mobile' | 'fixe';
}
export interface IRepresentative {
  id: string;
  civilite: Civility;
  firstName: string;
  lastName: string;
  type: RelationType;
  parentFirstName: string;
  parentLastName: string;
  address: AddressData;
  schedule: SelectedDaysType;
  mobile?: string[] ;
  fixe?: string[] ;
  personne?: string[];
  email: string;
  circuit: string;
  autoParentale?: string;
  notificationArivee?: string;
  observation?: string;
  adresseEtablissement?: AddressData;
}

export interface IAvenantUsager {
  id: string;
  numeroAvenant: string;
  dateApplication: string;
  codeCircuit: string;
  intituleCircuit: string;
  objetAvenant: string;
  specificite?: string;
  avenantTemporaire?: string;
  etablissement?: string[];
  jours?: JoursAttribues[]
  observation?: string;
  actionAvenant?: string;
}

export enum ActionAvenantType {
  AJOUT_USAGER = "ajout_usager",
  SUPPRESSION_USAGER = "suppression_usager",
  MODIF_HORRAIRE = "modif_horraire",
  MODIF_ADRESSE = "modif_adresse"
}

export interface SelectedDaysType {
  pair: { [key: string]: { all: boolean; ret: boolean } };
  impair: { [key: string]: { all: boolean; ret: boolean } };
}

export type TimeValue = Date | Dayjs | null

export type IPreparationUsager = {
  id: string
  nom: string
  prenom: string
  circuit: string
  code: string
  etablissement?: string[]
  jours?: JoursAttribues[]
  adressEtb?: AddressData[]
  adresse: AddressData
  dateNaissance: string
  dateAvenant: string
  observation?: string
  etat?: string
  debutTransport?: string
  categorie?: string
  specificite?: string
  transportSpecificity?: string
  class?: string
};