export enum VacationType {
  NOEL = "Vacances de Noël",
  HIVER = "Vacances d'hiver",
  PRINTEMPS = "Vacances de printemps",
  ETE = "Vacances d'été",
  TOUSSAINT = "Vacances de la Toussaint",
}
  
  export enum ZoneType {
    A = "A",
    B = "B",
    C = "C"
  }
 
  export enum RegionType {
    ILEDEFRANCE = "ile-de-france",
    NORMANDIE = "normandie",
    BRETAGNE = "bretagne"
  }
  
  export interface IVacance {
    id: string
    numeroPeriode: string
    etablissement: string
    zone: ZoneType
    region: string
    departement: string
    dateDebut: string
    dateFin: string
    type: VacationType
    isActive:boolean;
  }
  
  export interface ZoneVacation {
    id: string
    mois: string
    de: string
    a: string
    type: string
  }
  
  export interface Zone {
    id: string
    name: string
    vacations: ZoneVacation[]
  }

  export interface IFileImport {
    id: string
    fileName: string
    importDate: string
    importedBy: string
    zones?: Zone[] 
  }