import { PeriodType } from "./driver-roadmap";

export type ValidatedRouteSheetRoute = {
    id: number;
    type: PeriodType;
    startHour: Date;
    endHour: Date;
  }

  export type ValidatedRouteSheetDay = {
    id: number;
    date: Date;
    validatedRouteList: ValidatedRouteSheetRoute[]; 
    routeSheetTotal:RouteSheetTotal;
  }

  export type ValidatedRouteSheetTable = {
    id: number;
    date: Date;
    routeSheetDayList: ValidatedRouteSheetDay[]; 
  }
 

export type RouteSheetTotal = {
    id: number;
    totalDay: string;
    totalCentieme: string;
    deduction: string;
    paidHoursCentieme: string;
    delta: string;
    forfait: string;
    nightHours: string;
    waitingHours: string;
    numberVacations: number;
  }
