'use client';

import AuthGuard from '@/contexts/auth/guard/auth-guard';
import DashboardLayout from '@/layouts/dashboard';
import { SnackbarProvider } from 'notistack';
// ----------------------------------------------------------------------

type Props = {
  children: React.ReactNode;
};

export default function Layout({ children }: Props) {
  return (
    <SnackbarProvider maxSnack={3} anchorOrigin={{ vertical: 'top', horizontal: 'right' }}>
        <AuthGuard>
          <DashboardLayout>
            {children}
          </DashboardLayout>
        </AuthGuard>
    </SnackbarProvider>
  );
}
