// app/layout.tsx

import { AuthProvider } from '@/contexts/auth/jwt';
import { NavBarProvider } from '@/contexts/settings/nav-bar-context';
import ThemeProvider from '@/shared/theme';
import { ReactNode } from 'react';

export const metadata = {
  title: 'VSN',
  manifest: '/manifest.json',
  icons: {
    apple: [
      { url: '/favicon/apple-icon-57x57.png', sizes: '57x57', type: 'image/png' },
      { url: '/favicon/apple-icon-60x60.png', sizes: '60x60', type: 'image/png' },
      { url: '/favicon/apple-icon-72x72.png', sizes: '72x72', type: 'image/png' },
      { url: '/favicon/apple-icon-76x76.png', sizes: '76x76', type: 'image/png' },
      { url: '/favicon/apple-icon-114x114.png', sizes: '114x114', type: 'image/png' },
      { url: '/favicon/apple-icon-120x120.png', sizes: '120x120', type: 'image/png' },
      { url: '/favicon/apple-icon-144x144.png', sizes: '144x144', type: 'image/png' },
      { url: '/favicon/apple-icon-152x152.png', sizes: '152x152', type: 'image/png' },
      { url: '/favicon/apple-icon-180x180.png', sizes: '180x180', type: 'image/png' },
    ],
    icon: [
      { url: '/favicon/favicon-32x32.png', sizes: '32x32', type: 'image/png' },
      { url: '/favicon/favicon-96x96.png', sizes: '96x96', type: 'image/png' },
      { url: '/favicon/favicon-16x16.png', sizes: '16x16', type: 'image/png' },
      { url: '/favicon/android-icon-192x192.png', sizes: '192x192', type: 'image/png' },
    ],
  },
};
export default function Layout({ children }: { children: ReactNode }) {
  return (
    <html lang="en">
      <body >
      <AuthProvider>
        <ThemeProvider>
          <NavBarProvider>
          <main >{children}</main>
          </NavBarProvider>
        </ThemeProvider>
        </AuthProvider>
      </body>
    </html>
  );
}
