import { Document } from '@/shared/types/document';
import { PrioriteDemande } from '../types/demande';

export const STATUS_OPTIONS = [
  { label: 'Traité', value: 'traité' },
  { label: 'Non traité', value: 'non traité' },
];

export const _documentsRh: Document[] = [
  {
    id: '1',
    name: 'John Doe',
    type: 'contrat',
    categoryId: 'RH',
    uploadDate: new Date('2024-01-15'),
    lastModified: new Date('2024-01-15'),
    path: '/documents/contrats/contrat-1.pdf',
    status: 'traité',
    isArchived: false,
    requester: {
      id: '1',
      name: 'John Doe',
      email: 'john.doe@example.com'
    },
    file: {
      name: 'document',
      extension: 'pdf',
      size: '1.2 MB',
      uploadDate: '2024-03-20'
    },
    priority: PrioriteDemande.BASSE
  },
  {
    id: '2',
    name: 'Jane Smith',
    type: 'attestation',
    categoryId: 'PAIE',
    uploadDate: new Date('2024-02-01'),
    lastModified: new Date('2024-02-05'),
    path: '/documents/attestations/attestation-1.pdf',
    status: 'non traité',
    isArchived: false,
    requester: {
      id: '2',
      name: 'Jane Smith',
      email: 'jane.smith@example.com'
    },
    file: {
      name: 'document',
      extension: 'pdf',
      size: '1.2 MB',
      uploadDate: '2024-03-20'
    },
    priority: PrioriteDemande.NORMALE
  },
  {
    id: '3',
    name: 'Mike Johnson',
    type: 'fiche de paie',
    categoryId: 'PAIE',
    uploadDate: new Date('2024-02-01'),
    lastModified: new Date('2024-02-01'),
    path: '/documents/paie/paie-jan-2024.pdf',
    status: 'traité',
    isArchived: false,
    requester: {
      id: '3',
      name: 'Robert Johnson',
      email: 'robert.j@example.com'
    },
    file: {
      name: 'document',
      extension: 'pdf',
      size: '1.2 MB',
      uploadDate: '2024-03-20'
    },
    priority: PrioriteDemande.HAUTE
  },
  {
    id: '4',
    name: 'Sarah Wilson',
    type: 'contrat',
    categoryId: 'RH',
    uploadDate: new Date('2024-03-01'),
    lastModified: new Date('2024-03-01'),
    path: '/documents/contrats/contrat-cdd-1.pdf',
    status: 'non traité',
    isArchived: false,
    requester: {
      id: '1',
      name: 'John Doe',
      email: 'john.doe@example.com'
    },
    file: {
      name: 'document',
      extension: 'pdf',
      size: '1.2 MB',
      uploadDate: '2024-03-20'
    },
    priority: PrioriteDemande.URGENTE
  },
  {
    id: '5',
    name: 'Alex Martin',
    type: 'attestation',
    categoryId: 'RH',
    uploadDate: new Date('2024-02-15'),
    lastModified: new Date('2024-02-15'),
    path: '/documents/attestations/pole-emploi-1.pdf',
    status: 'traité',
    isArchived: false,
    requester: {
      id: '1',
      name: 'John Doe',
      email: 'john.doe@example.com'
    },
    file: {
      name: 'document',
      extension: 'pdf',
      size: '1.2 MB',
      uploadDate: '2024-03-20'
    },
    priority: PrioriteDemande.URGENTE
  },
  {
    id: '6',
    name: 'Mike Johnson',
    type: 'fiche de paie',
    categoryId: 'PAIE',
    uploadDate: new Date('2024-03-01'),
    lastModified: new Date('2024-03-01'),
    path: '/documents/paie/paie-feb-2024.pdf',
    status: 'non traité',
    isArchived: false,
    requester: {
      id: '3',
      name: 'Robert Johnson',
      email: 'robert.j@example.com'
    },
    file: {
      name: 'document',
      extension: 'pdf',
      size: '1.2 MB',
      uploadDate: '2024-03-20'
    },
    priority: PrioriteDemande.URGENTE
  },
  {
    id: '7',
    name: 'John Doe',
    type: 'contrat',
    categoryId: 'RH',
    uploadDate: new Date('2024-02-20'),
    lastModified: new Date('2024-02-20'),
    path: '/documents/contrats/avenant-1.pdf',
    status: 'traité',
    isArchived: false,
    requester: {
      id: '1',
      name: 'John Doe',
      email: 'john.doe@example.com'
    },
    file: {
      name: 'document',
      extension: 'pdf',
      size: '1.2 MB',
      uploadDate: '2024-03-20'
    },
    priority: PrioriteDemande.URGENTE
  },
  {
    id: '8',
    name: 'Emma Brown',
    type: 'attestation',
    categoryId: 'RH',
    uploadDate: new Date('2024-03-05'),
    lastModified: new Date('2024-03-05'),
    path: '/documents/attestations/mutuelle-1.pdf',
    status: 'non traité',
    isArchived: false,
    requester: {
      id: '1',
      name: 'John Doe',
      email: 'john.doe@example.com'
    },
    file: {
      name: 'document',
      extension: 'pdf',
      size: '1.2 MB',
      uploadDate: '2024-03-20'
    },
    priority: PrioriteDemande.URGENTE
  },
  {
    id: '9',
    name: 'David Clark',
    type: 'autre',
    categoryId: 'PAIE',
    uploadDate: new Date('2024-03-10'),
    lastModified: new Date('2024-03-10'),
    path: '/documents/notes/frais-1.pdf',
    status: 'traité',
    isArchived: false,
    requester: {
      id: '3',
      name: 'Robert Johnson',
      email: 'robert.j@example.com'
    },
    file: {
      name: 'document',
      extension: 'pdf',
      size: '1.2 MB',
      uploadDate: '2024-03-20'
    },
    priority: PrioriteDemande.URGENTE
  },
  {
    id: '10',
    name: 'Équipe logistique',
    type: 'autre',
    categoryId: 'RH',
    uploadDate: new Date('2024-03-15'),
    lastModified: new Date('2024-03-15'),
    path: '/documents/formations/securite-1.pdf',
    status: 'non traité',
    isArchived: false,
    requester: {
      id: '1',
      name: 'John Doe',
      email: 'john.doe@example.com'
    },
    file: {
      name: 'document',
      extension: 'pdf',
      size: '1.2 MB',
      uploadDate: '2024-03-20'
    },
    priority: PrioriteDemande.URGENTE
  }
];
export const initialDocumentRh: Document = {
  id: '',
  name: '',
  type: 'contrat',
  categoryId: 'RH',
  uploadDate: new Date(),
  lastModified: new Date(),
  path: '',
  status: 'non traité',
  isArchived: false,
  customType: undefined,
  requester: {
    id: '',
    name: '',
    email: ''
  },
  priority: PrioriteDemande.BASSE
};