import type { TableColumn } from "@/shared/types/common"
import { ExportTab, IExport, ExportModuleType } from "../types/export"
import { BinaryQuestion } from "../types/trajet"

export const DEFAULT_EXPORT_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "Job Id", type: "text", width: 80 },
  { id: "exportFilesStatus", label: "Statut", type: "status", width: 100 },
  { id: "moduleType", label: "Module", type: "text", width: 120 },
  { id: "startTime", label: "Date début", type: "date", width: 150 },
  { id: "endTime", label: "Date fin", type: "date", width: 150 },
  { id: "whoRunExport", label: "Utilisateur", type: "text", width: 120 },
  { id: "filePath", label: "Nom du fichier", type: "text", width: 180 },
  { id: "downloaded", label: "Téléchargé", type: "status", width: 100 },
  { id: "fileSize", label: "Taille", type: "text", width: 50 },
  { id: "", label: "", width: 88 },
]

export const _EXPORT_OPTION_STATUT = [
  { value: ExportTab.COMPLETED, label: "Complété" },
  { value: ExportTab.IN_PROGRESS, label: "En cours" },
  { value: ExportTab.FAILED, label: "Échoué" },
]


export const _exports: IExport[] = [
  {
    id: "35",
    exportFilesStatus: ExportTab.COMPLETED,
    moduleType: ExportModuleType.CONTRAT,
    startTime: "16 May 2025 14:56",
    endTime: "16 May 2025 14:56",
    whoRunExport: "admin vsn",
    filePath: "commande_d383350d-46b6-46ce-b143-6024762b5a48.csv",
    downloaded: BinaryQuestion.Oui,
    fileSize: "7.51 KB",
  },
  {
    id: "34",
    exportFilesStatus: ExportTab.COMPLETED,
    moduleType: ExportModuleType.CIRCUIT,
    startTime: "13 May 2025 15:44",
    endTime: "13 May 2025 15:44",
    whoRunExport: "admin vsn",
    filePath: "commande_7fe0c015-3536-409f-8524-1849c4659def.csv",
    downloaded: BinaryQuestion.Oui,
    fileSize: "74.55 KB",
  },
  {
    id: "33",
    exportFilesStatus: ExportTab.COMPLETED,
    moduleType: ExportModuleType.TRAJET,
    startTime: "13 May 2025 15:43",
    endTime: "13 May 2025 15:43",
    whoRunExport: "admin vsn",
    filePath: "commande_be6e7f30-0211-4bad-971c-2c9d66d3d42e.csv",
    downloaded: BinaryQuestion.Oui,
    fileSize: "13.17 KB",
  },
  {
    id: "31",
    exportFilesStatus: ExportTab.IN_PROGRESS,
    moduleType: ExportModuleType.CHAUFFEUR,
    startTime: "13 May 2025 15:43",
    endTime: "13 May 2025 15:43",
    whoRunExport: "admin vsn",
    filePath: "commande_7f20f799-c954-4921-9a71-3fd0ece41b7d.csv",
    downloaded: BinaryQuestion.Non,
    fileSize: "13.17 KB",
  },
  {
    id: "28",
    exportFilesStatus: ExportTab.COMPLETED,
    moduleType: ExportModuleType.USAGER,
    startTime: "12 May 2025 17:59",
    endTime: "12 May 2025 17:59",
    whoRunExport: "admin vsn",
    filePath: "commande_ec840b21-9664-480e-8228-7031939810ba.csv",
    downloaded: BinaryQuestion.Oui,
    fileSize: "73.17 KB",
  },
  {
    id: "27",
    exportFilesStatus: ExportTab.FAILED,
    moduleType: ExportModuleType.CLIENT,
    startTime: "11 May 2025 10:30",
    endTime: "11 May 2025 10:32",
    whoRunExport: "admin vsn",
    filePath: "commande_failed_export.csv",
    downloaded: BinaryQuestion.Non,
    fileSize: "0 KB",
  },
]
