import { IFormulaire } from '@/shared/types/formulaire';
import { TableColumn } from '@/shared/types/common';
import { nanoid } from 'nanoid';

// Table Heads
export const DEFAULT_FORMULAIRE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'ID', type: 'text', align: 'left' },
  { id: 'title', label: 'title', type: 'text', align: 'left' },
  { id: 'description', label: 'Description', type: 'text', align: 'left' },
  { id: 'creator', label: 'Créateur', type: 'text', align: 'left' },
  { id: 'category', label: 'Catégorie', type: 'text', align: 'left' },
  { id: 'createdDate', label: 'Date de création', type: 'date', align: 'left' },
  { id: 'actions', label: 'Actions',  align: 'right' },
];

// Sample data
export let _formulaires: IFormulaire[] = [
  {
    id: 'form-1',
    title: 'Évaluation de performance',
    description: 'Formulaire d\'évaluation annuelle des performances',
    createdDate: '2023-05-15T10:30:00.000Z',
    lastModifiedDate: '2023-06-10T14:45:00.000Z',
    creator: 'Jean Dupont',
    category: 'evaluation',
    department: 'Ressources humaines',
    fields: [
      {
        id: 'field-1',
        label: 'Nom de l\'employé',
        type: 'text',
        required: true,
      },
      {
        id: 'field-2',
        label: 'Poste occupé',
        type: 'text',
        required: true,
      },
      {
        id: 'field-3',
        label: 'Période d\'évaluation',
        type: 'text',
        required: true,
      },
      {
        id: 'field-4',
        label: 'Objectifs atteints',
        type: 'textarea',
        required: true,
      },
      {
        id: 'field-5',
        label: 'Points à améliorer',
        type: 'textarea',
        required: true,
      },
      {
        id: 'field-6',
        label: 'Note globale',
        type: 'select',
        required: true,
        options: [
          { value: '1', label: '1 - Insuffisant' },
          { value: '2', label: '2 - À améliorer' },
          { value: '3', label: '3 - Satisfaisant' },
          { value: '4', label: '4 - Très bon' },
          { value: '5', label: '5 - Excellent' },
        ],
      },
    ],
  },
  {
    id: 'form-2',
    title: 'Demande de congés',
    description: 'Formulaire de demande de congés payés',
    createdDate: '2023-03-20T08:15:00.000Z',
    lastModifiedDate: '2023-04-05T11:30:00.000Z',
    creator: 'Marie Martin',
    category: 'conges',
    department: 'Ressources humaines',
    fields: [
      {
        id: 'field-1',
        label: 'Date de début',
        type: 'date',
        required: true,
      },
      {
        id: 'field-2',
        label: 'Date de fin',
        type: 'date',
        required: true,
      },
      {
        id: 'field-3',
        label: 'Type de congé',
        type: 'select',
        required: true,
        options: [
          { value: 'cp', label: 'Congés payés' },
          { value: 'rtt', label: 'RTT' },
          { value: 'maladie', label: 'Congé maladie' },
          { value: 'familial', label: 'Congé familial' },
        ],
      },
      {
        id: 'field-4',
        label: 'Commentaires',
        type: 'textarea',
        required: false,
      },
    ],
  },
  {
    id: 'form-3',
    title: 'Entretien d\'embauche',
    description: 'Formulaire d\'évaluation pour les entretiens d\'embauche',
    createdDate: '2023-04-20T14:30:00.000Z',
    lastModifiedDate: '2023-05-18T09:45:00.000Z',
    creator: 'Sophie Leblanc',
    category: 'recrutement',
    department: 'Ressources humaines',
    fields: [
      {
        id: 'field-1',
        label: 'Nom du candidat',
        type: 'text',
        required: true,
      },
      {
        id: 'field-2',
        label: 'Poste',
        type: 'text',
        required: true,
      },
      {
        id: 'field-3',
        label: 'Impressions générales',
        type: 'textarea',
        required: true,
      },
      {
        id: 'field-4',
        label: 'Niveau technique',
        type: 'select',
        required: true,
        options: [
          { value: '1', label: '1 - Débutant' },
          { value: '2', label: '2 - Intermédiaire' },
          { value: '3', label: '3 - Confirmé' },
          { value: '4', label: '4 - Expert' },
        ],
      },
    ],
  },
  {
    id: 'form-4',
    title: 'Demande de formation',
    description: 'Formulaire de demande de formation professionnelle',
    createdDate: '2022-11-10T11:20:00.000Z',
    lastModifiedDate: '2023-01-05T16:40:00.000Z',
    creator: 'Thomas Petit',
    category: 'formation',
    department: 'Ressources humaines',
    fields: [
      {
        id: 'field-1',
        label: 'Intitulé de la formation',
        type: 'text',
        required: true,
      },
      {
        id: 'field-2',
        label: 'Organisme de formation',
        type: 'text',
        required: true,
      },
      {
        id: 'field-3',
        label: 'Date de début',
        type: 'date',
        required: true,
      },
      {
        id: 'field-4',
        label: 'Durée (jours)',
        type: 'number',
        required: true,
      },
      {
        id: 'field-5',
        label: 'Justification',
        type: 'textarea',
        required: true,
      },
    ],
  },
  {
    id: 'form-5',
    title: 'Fiche de poste',
    description: 'Formulaire pour créer une fiche de poste',
    createdDate: '2023-06-01T09:10:00.000Z',
    lastModifiedDate: '2023-06-02T14:25:00.000Z',
    creator: 'Laure Dubois',
    category: 'administration',
    department: 'Ressources humaines',
    fields: [
      {
        id: 'field-1',
        label: 'Intitulé du poste',
        type: 'text',
        required: true,
      },
      {
        id: 'field-2',
        label: 'Département',
        type: 'text',
        required: true,
      },
      {
        id: 'field-3',
        label: 'Missions principales',
        type: 'textarea',
        required: true,
      },
      {
        id: 'field-4',
        label: 'Compétences requises',
        type: 'textarea',
        required: true,
      },
      {
        id: 'field-5',
        label: 'Expérience nécessaire',
        type: 'select',
        required: true,
        options: [
          { value: 'junior', label: 'Junior (0-2 ans)' },
          { value: 'intermediaire', label: 'Intermédiaire (2-5 ans)' },
          { value: 'senior', label: 'Senior (5-10 ans)' },
          { value: 'expert', label: '10+ ans' },
        ],
      },
    ],
  },
];

// Function to add or update a formulaire in the mock data
export const updateFormulaire = (formulaire: IFormulaire): IFormulaire => {
  // Check if formulaire already exists
  const index = _formulaires.findIndex(f => f.id === formulaire.id);
  
  if (index >= 0) {
    // Update existing formulaire
    _formulaires[index] = formulaire;
  } else {
    // Add new formulaire
    _formulaires = [..._formulaires, formulaire];
  }
  
  return formulaire;
}

// Function to delete a formulaire from the mock data
export const deleteFormulaire = (id: string): boolean => {
  const initialLength = _formulaires.length;
  _formulaires = _formulaires.filter(f => f.id !== id);
  
  // Return true if a formulaire was deleted
  return _formulaires.length < initialLength;
} 