
import { TableColumn } from "../types/common";
import { ILanguageSettings } from "../types/ILanguageSettings";


export const _LANGUAGE_STATUS = [
  { value: "active", label: "Actif" },
  { value: "inactive", label: "Inactif" },
];

export const _languageSettings: ILanguageSettings[] = [...Array(10)].map((_, index) => ({
  id: (index + 1).toString(),
  language: ['fr', 'en', 'ar'][index % 3],
  region: ['FR', 'MA', 'TN'][index % 3],
  dateFormat: ['DD/MM/YYYY', 'MM/DD/YYYY', 'YYYY-MM-DD'][index % 3],
  timeFormat: ['24', '12'][index % 2],
  timezone: ['Europe/Paris', 'Africa/Casablanca', 'Africa/Tunis'][index % 3],
  currency: ['EUR', 'MAD', 'TND'][index % 3],
  numberFormat: ['fr-FR', 'en-US', 'ar-MA'][index % 3],
  isActive: Math.random() < 0.7,
  status: _LANGUAGE_STATUS[index % 2].value,
}));

export const DEFAULT_TABLE_HEAD: TableColumn[] = [
  { id: 'language', label: 'Langue', type: 'text' },
  { id: 'region', label: 'Région', type: 'text' },
  { id: 'dateFormat', label: 'Format de date', type: 'text' },
  { id: 'timeFormat', label: 'Format heure', type: 'text' },
  { id: 'currency', label: 'Devise', type: 'text' },
  { id: 'status', label: 'Statut', type: 'status' },
  { id: 'isActive', label: 'Actif', type: 'boolean' },
  { id: '', label: 'Action' },
];

export const INITIAL_LANGUAGE_SETTINGS: ILanguageSettings = {
  id: '',
  language: 'fr',
  region: 'FR',
  dateFormat: 'DD/MM/YYYY',
  timeFormat: '24',
  timezone: 'Europe/Paris',
 
  numberFormat: 'fr-FR',
  isActive: true,

};