import { _noms, _prenoms, ADRESSE, MOCK_ADDRESSES } from ".";
import { JoursAttribues } from "../types/chauffeur";
import { IPreparationUsager } from "../types/usager";

  
export const _passengerPreparation = [...Array(50)].map((_, index) => {
  const startDate = new Date(2022+ Math.floor(index / 12), index % 12, 15);
  const endDate = new Date(startDate.getFullYear() + 2, Math.floor(Math.random() * 12), 1);
  const mockAddress = MOCK_ADDRESSES[index % 4];

    return {
      id: (index + 1).toString(),
      nom: _noms[index % 4],
      prenom: _prenoms[index % 4],
      circuit:  `La Traversée Parisienne ${index + 1}`,
      code: `${(index + 1).toString().padStart(7, '0')}`,
      etablissement: ['les_champs', 'la_colline', 'le_rivage', 'la_foret'].slice(index % 4, index % 4 + 1),
      dateNaissance: startDate.toISOString().split('T')[0],
      dateAvenant: endDate.toISOString().split('T')[0],
      adresse: mockAddress,
    };
  });
  
export const DEFAULT_PASSENGER_PREPARATION_TABLE_HEAD = [
  { id: 'id', label: 'N°', type: 'text', align: 'center'},
  { id: 'nom', label: 'Nom', type: 'text'},
  { id: 'prenom', label: 'Prénom', type: 'text'},
  { id: 'etablissement', label: 'Établissement', type: 'text'},
  { id: 'adresse', label: 'Adresse', type: 'text'},
  { id: '', label: 'Action' },
];
  
export const INITIAL_PASSENGER_PREPARATION_DATA: IPreparationUsager = {
  id: '',
  nom: '',
  prenom: '',
  circuit: '',
  code: '',
  etablissement: [],
  jours: [],
  adressEtb: [],
  adresse: {
    address: '',
    lat: 0,
    lng: 0,
    placeId: '',
    formattedAddress: '',
    city: '',
    postalCode: '',
    country: ''
  },
  dateNaissance: '',
  dateAvenant: '',
  etat: '',
  debutTransport: '',
  categorie: '',
  specificite: '',
  transportSpecificity: '',
  class: ''
};

  export const INITIAL_JOURS_ATTRIBUES_DATA: JoursAttribues = {
      pair: {
      lundi: { matin: false, soir: false },
      mardi: { matin: false, soir: false },
      mercredi: { matin: false, soir: false },
      jeudi: { matin: false, soir: false },
      vendredi: { matin: false, soir: false },
      samedi: { matin: false, soir: false },
      dimanche: { matin: false, soir: false },
    },
    impair: {
      lundi: { matin: false, soir: false },
      mardi: { matin: false, soir: false },
      mercredi: { matin: false, soir: false },
      jeudi: { matin: false, soir: false },
      vendredi: { matin: false, soir: false },
      samedi: { matin: false, soir: false },
      dimanche: { matin: false, soir: false },
    },
  }