import { TableColumn } from "@/shared/types/common";
import { _OPTION_STATUT } from "./_intervention";
import { _CHAUFFEURS } from "../_absenceDriver";
import { generateDateRange } from "..";
import { AFFECTATION_OPTION_STATUT, AffectationStatut, IVehicleAffectation } from "@/shared/types/flottes/vehicle-affectation";
import { _vehicles } from "./_vehicle";

export const _vehicleAffectations: IVehicleAffectation[] = [...Array(40)].map((_, i) => {
  const { startDate, endDate } = generateDateRange(i)
  
  return {
    id: (i+1).toString(),
    chauffeur: _CHAUFFEURS[i % _CHAUFFEURS.length] ,
    marque: _vehicles[i].marque,
    modele: _vehicles[i].modele,
    numeroImmatriculation: _vehicles[i].numeroImmatriculation,
    dateAffectation: startDate,
    dateRetour: endDate,
    statut: AFFECTATION_OPTION_STATUT[i % 2].value,
    isActive: Math.random() < 0.8,
  }
});


export const DEFAULT_AFFECTAITON_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'Id', type: 'text' },
  { id: 'chauffeur', label: 'Chauffeur', type: 'text' },
  { id: 'marque', label: 'Marque', type: 'text' },
  { id: 'modele', label: 'Modèle', type: 'text' },
  { id: 'numeroImmatriculation', label: 'Immatriculation', type: 'text' },
  { id: 'dateAffectation', label: "Date d'affectation", type: 'date', align: 'center' },
  { id: 'dateRetour', label: "Date de Retour", type: 'date', align: 'center' },
  { id: "statut", label: "Statut", type: "text" },
  { id: 'isActive', label: 'Active', type: 'boolean',align: 'center' },
  { id: "", label: "Action" },
];

export const INITIAL_AFFECTATION_DATA: IVehicleAffectation = {
  id: "",
  chauffeur: "",
  marque:  "",
  modele:  "",
  numeroImmatriculation:  "",
  dateAffectation: "",
  dateRetour: "",
  statut: AffectationStatut.EnCours,
  isActive: true,
}