import { TableColumn } from "@/shared/types/common";
import { IVehicle, IVehicleModel, IVehicleType, VehicleStatut } from "@/shared/types/flottes/vehicule";
import { _OPTION_STATUT } from "./_intervention";
import { DEPARTEMENT_OPTIONS } from "@/shared/sections/establishment/attendance/utils/form-fields-attendance";
import { _CHAUFFEURS } from "../_absenceDriver";
import { _MARQUES, _MODELES, generateStartDate, IMMATRICULATIONS } from "..";
import { _supplierTypes } from "./_supplier";


const _TYPES_VEHICULE = [
  "PMR 5 PL",
  "4 PLACES",
  "7 places",
  "9 places",
  "SUV",
  "TPMR",
  "citadine",
  "PEUGEOT 208",
  "BERLINE 5P"
];
export const _OPTION_VEHICLE_TYPE = [
  { value: 'Minibus', label: 'Minibus' },
  { value: 'Van', label: 'Van' },
  { value: 'Bus', label: 'Bus' },
  { value: 'Navette', label: 'Navette' },
];

export const _VEHICLE_OPTION_STATUT = [
  { value: VehicleStatut.EnCours, label: "Réparation en cours" },
  { value: VehicleStatut.Affecte, label: "Affecter" },
  { value: VehicleStatut.NonAffecte, label: "Non Affecter" },
]

export const _vehicles: IVehicle[] = [...Array(40)].map((_, i) => {
  
  const dateImmat = new Date(2022 + Math.floor(i / 12), i % 12, 15).toISOString().split('T')[0];
  const places = 8 + Math.floor(Math.random() * 13);
  const placesFR = i % 3 === 0 ? places : Math.floor(Math.random() * 6);
  const statut = _VEHICLE_OPTION_STATUT[i % 3].value
  const driver = statut === VehicleStatut.Affecte ? _CHAUFFEURS[i % _CHAUFFEURS.length] : ""
  return {
    id: `${(i + 1).toString().padStart(7, '0')}`,
    marque: _MARQUES[i % _MARQUES.length],
    modele: _MODELES[i % _MODELES.length],
    numeroImmatriculation: IMMATRICULATIONS[i % IMMATRICULATIONS.length],
    statut: statut,
    chauffeur: driver,
    typeVehicule: _TYPES_VEHICULE[i % _TYPES_VEHICULE.length],
    department: DEPARTEMENT_OPTIONS[i % DEPARTEMENT_OPTIONS.length].label,
    nombrePlaces: places.toString(),
    placesFauteuilRoulant: placesFR.toString(),
    dateImmatriculation: dateImmat,
    providerType: _supplierTypes[i % _supplierTypes.length],
    isActive:Math.random() < 0.6,
  };
});

export const DEFAULT_VEHICLE_TABLE_HEAD: TableColumn[] = [
  { id: 'id', label: 'Id', type: 'text' },
  { id: 'marque', label: 'Marque', type: 'text' },
  { id: 'modele', label: 'Modèle', type: 'text' },
  { id: "statut", label: "Statut", type: "text" },
  { id: 'numeroImmatriculation', label: 'Immatriculation', type: 'text' },
  { id: 'chauffeur', label: 'Chauffeur', type: 'text' },
  { id: 'typeVehicule', label: 'Type de véhicule', type: 'text' },
  { id: 'department', label: 'Département', type: 'text' },
  { id: 'nombrePlaces', label: 'Nombre de places', type: 'text', align: 'center' },
  { id: 'placesFauteuilRoulant', label: 'Places fauteuil roulant', type: 'text', align: 'center' },
  { id: 'dateImmatriculation', label: 'Date immatriculation', type: 'date', align: 'center' },
  { id: 'providerType', label: 'Fournisseur', type: 'text', align: 'center' },
  { id: 'isActive', label: 'Active', type: 'boolean',align: 'center' },
  { id: "", label: "Action" },
];

export const INITIAL_VEHICLE_DATA: IVehicle = {
  id: '',
  marque: '',
  modele: '',
  numeroImmatriculation: '',
  chauffeur: '',
  typeVehicule: '',
  providerType: _supplierTypes[0],
  statut: "",
  department: '',
  nombrePlaces: '',
  placesFauteuilRoulant: '',
  dateImmatriculation: '',
  isActive: true,
};

//Modéles & Marques
export const _VehicleModels: IVehicleModel[] = [...Array(30)].map((_, i) => {
  return {
    id: (i + 1).toString(),
    dateEntretien: generateStartDate(i),
    marque: _MARQUES[i % _MARQUES.length],
    modele: _MODELES[i % _MODELES.length],
    isActive: Math.random() < 0.8,
  }
})

export const DEFAULT_VEHICLE_MODEL_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "marque", label: "Marque", type: "text" },
  { id: "modele", label: "Modèle", type: "text" },
  { id: "dateEntretien", label: "Date d'entretien", type: "date" },
  { id: "isActive", label: "Actif", type: "boolean", align: "center" },
  { id: "", label: "Action" },
]

export const INITIAL_VEHICLE_MODEL_DATA: IVehicleModel = {
  id: "",
  dateEntretien: "",
  marque: "",
  modele: "",
  isActive: true,
}

//type de véhicule
export const _VehicleTypes: IVehicleType[] = [...Array(20)].map((_, i) => {

  return {
    id: (i + 1).toString(),
    intitule: _TYPES_VEHICULE[i % _TYPES_VEHICULE.length],
    isActive: Math.random() < 0.8,
  }
})

export const DEFAULT_VEHICLE_TYPE_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "intitule", label: "Type  de Véhicule", type: "text" },
  { id: "isActive", label: "Actif", type: "boolean", align: "center" },
  { id: "", label: "Action" },
]

export const INITIAL_VEHICLE_TYPE_DATA: IVehicleType = {
  id: "",
  intitule: "",
  isActive: true,
}
