
const API_URL = '/api/circuit';

export const endpoints_Trajet = {
    
Trajet: {
    getTrajetsPage: `${API_URL}/statistiques/trips`,
    getTrajetById: (id: string) => `${API_URL}/trips/${id}`,
    createTrajet: `${API_URL}/trips`,
    updateTrajet: (id: string) => `${API_URL}/statistiques/trips/${id}`,
    toggleTrajetActivation: (id: string, isActive: boolean) => 
      `${API_URL}/trips/${id}/toggle-activation?isActive=${isActive}`,
    updateTrajetStatus: (id: string, field: string) => 
      `${API_URL}/trips/${id}/status?field=${field}`,
    getSuiviTrajets: (id: string) => `${API_URL}/statistiques/trips/${id}/suivi`,
    updateSuiviTrajets: (id: string) => `${API_URL}/statistiques/trips/${id}/suivi`,
    addTripPoint: (id: string) => `${API_URL}/trip-points`,
    deleteTripPoint: (id: string) => `${API_URL}/trip-points/${id}`,
    reorderTripPoints: (id: string) => `${API_URL}/trip-points/reorder?tripId=${id}`,
    exportTrajetDataInCsv: `${API_URL}/trips/export/csv`,
    exportTrajetDataInPdf: `${API_URL}/trips/export/pdf`,
    filterTrajets: `${API_URL}/statistiques/trips`,
    TripPoint: {
      getPoints: (tripId: string) => `${API_URL}/trip-points/trip/${tripId}`,
      addPoint: `${API_URL}/trip-points`,
      updatePoint: (pointId: string) => `${API_URL}/trip-points/${pointId}`,
      deletePoint: (pointId: string) => `${API_URL}/trip-points/${pointId}`,
      reorderPoints: (tripId: string) => `${API_URL}/trip-points/reorder?tripId=${tripId}`,
    }
  },
}