import axiosInstance from "@/utils/axios";
import { create } from "zustand";
import { ITripDriverAssignment } from "@/shared/types/circuit";
import { circuitEndpoints } from "../../endpoints/circuit";

interface TripDriverAssignmentStore {
    loading: boolean;
    error: string | null;
    addTripDriverAssignment: (assignment: ITripDriverAssignment) => Promise<void>;
    updateTripDriverAssignment: (assignment: ITripDriverAssignment) => Promise<void>;
}

export const useTripDriverAssignmentStore = create<TripDriverAssignmentStore>((set) => ({
    loading: false,
    error: null,

    addTripDriverAssignment: async (assignment) => {
        set({ loading: true, error: null });
        try {
            await axiosInstance.post(circuitEndpoints.circuit.tripDriverAssignment.add, assignment);
            set({ loading: false });
        } catch (error: any) {
            set({
                error: error.message || "Erreur lors de l'ajout de l'affectation chauffeur-trajet",
                loading: false,
            });
            throw error;
        }
    },

    updateTripDriverAssignment: async (assignment) => {
        set({ loading: true, error: null });
        try {
            await axiosInstance.post(circuitEndpoints.circuit.tripDriverAssignment.update(assignment.id), assignment);
            set({ loading: false });
        } catch (error: any) {
            set({
                error: error.message || "Erreur lors de la modification de l'affectation chauffeur-trajet",
                loading: false,
            });
            throw error;
        }
    },
}));
