"use client"

import { Box } from "@mui/material"
import { faCheck } from "@fortawesome/free-solid-svg-icons"
import FontAwesome from "../fontawesome"
import { SensARCheckbox } from "./style"

interface AttendanceCheckboxProps {
  checked: boolean
  onChange?: () => void
  disabled?: boolean
}

export const CustomCheckbox = ({ checked, onChange, disabled = false }: AttendanceCheckboxProps) => {
  return (
    <Box sx={{ position: "relative" }}>
      <SensARCheckbox 
        checked={checked} 
        sx={{ width: "16px", height: "16px" }} 
        onChange={onChange} 
        size="small" 
        disabled={disabled}
      />
      <FontAwesome
        sx={{
          color: disabled ? "grey.400" : "white",
          position: "absolute",
          top: "58%",
          left: "50%",
          transform: "translate(-50%, -50%)",
        }}
        width={12}
        icon={faCheck}
      />
    </Box>
  )
}