import type React from "react"
import { Box, Typography } from "@mui/material"
import SvgColor from "@/shared/components/svg-color"
import FontAwesome from "@/shared/components/fontawesome"
import { faClock } from "@fortawesome/free-solid-svg-icons"
import { containerStyles, InfoItem } from "./utils/journey-summary-utils"

interface JourneySummaryProps {
  distance: string
  duration: string
  trafficDate: string
  trafficTime: string
  isDrawerElement?: boolean
}

export const JourneySummary: React.FC<JourneySummaryProps> = ({
  distance,
  duration,
  trafficDate,
  trafficTime,
  isDrawerElement = false,
}) => {
  return (
    <Box sx={{ ...containerStyles(isDrawerElement)}}>
      <Box
        sx={{
          display: "flex",
          gap: 2,
          width: "100%",
          justifyContent: isDrawerElement ? "space-between" : { xs: "space-between", md: "space-around" },
        }}
      >
        <InfoItem
          icon={
            <SvgColor
              src="/assets/icons/menu/ic_exploitation.svg"
              sx={{ color: "primary.main", width: 16, height: 16 }}
            />
          }
          label="Distance :"
          value={distance}
        />
        <InfoItem
          icon={<FontAwesome icon={faClock} color="primary.main" width={16} />}
          label="Durée :"
          value={duration}
        />
      </Box>
      <Box
        sx={{
          display: "flex",
          gap: 2,
          width: "100%",
          justifyContent: isDrawerElement ? "space-between" : { xs: "space-between", md: "space-around" },
        }}
      >
        <InfoItem
          icon={<SvgColor src="/assets/icons/ic_date.svg" sx={{ color: "primary.main", width: 16, height: 16 }} />}
          label=""
          value={`avec traffic au ${trafficDate}`}
        />
        <Typography component="span" sx={{ fontSize: "0.875rem", color: "primary.main" }}>
          {trafficTime}
        </Typography>
      </Box>
    </Box>
  )
}

