import type React from "react"
import { Box, type SxProps, type Theme, Typography } from "@mui/material"

interface InfoItemProps {
  icon: React.ReactNode
  label?: string
  value: string
}

export const InfoItem: React.FC<InfoItemProps> = ({ icon, label, value }) => (
  <Box sx={{ display: "flex", alignItems: "center", gap: 1 }}>
    {icon}
    {label ? (
      <Typography component="span" sx={{ color: "primary.main", fontSize: "0.875rem", fontWeight: 500 }}>
        {label}
      </Typography>
    ) : <></>}
    <Typography component="span" sx={{ color: "primary.main", fontSize: "0.875rem" }}>
      {value}
    </Typography>
  </Box>
)

export const containerStyles = (isDrawer?: boolean, noRadius?: boolean): SxProps<Theme> => ({
  backgroundColor: "#F5F4FC",
  padding: 2,
  my: 2,
  borderRadius: noRadius ? 0 : 3,
  display: "flex",
  flexWrap: isDrawer ? "wrap" : { xs: "wrap", md: "nowrap" },
  justifyContent: "space-around",
  gap: 2,
})

