import React from "react";
import { Box, Typography } from "@mui/material";
import { styled } from "@mui/material/styles";
import type { DriverAbsence } from "../types";

interface AbsenceBlockProps {
    absence: DriverAbsence;
    width: number | string;
    height: number | string;
    top?: number;
}

const AbsenceContainer = styled(Box)(({ theme }) => ({
    position: "absolute",
    left: 0,
    borderRadius: theme.shape.borderRadius,
    padding: theme.spacing(0.5),
    overflow: "hidden",
    whiteSpace: "nowrap",
    textOverflow: "ellipsis",
    fontSize: "0.75rem",
    display: "flex",
    flexDirection: "column",
    alignItems: "center",
    justifyContent: "center",
    zIndex: 1,
}));

export const AbsenceBlock: React.FC<AbsenceBlockProps> = ({ absence, width, height, top = 0 }) => {
    const getAbsenceStyle = () => {
        switch (absence.type) {
            case "absence":
                return {
                    backgroundColor: "#FFCDD2",
                    color: "#B71C1C",
                    border: "1px solid #EF5350"
                };
            case "vacation":
                return {
                    backgroundColor: "#BBDEFB",
                    color: "#0D47A1",
                    border: "1px solid #42A5F5"
                };
            default:
                return {
                    backgroundColor: "#E0E0E0",
                    color: "#424242",
                    border: "1px solid #9E9E9E"
                };
        }
    };

    const absenceStyle = getAbsenceStyle();

    return (
        <AbsenceContainer
            sx={{
                width,
                height,
                top,
                ...absenceStyle,
            }}
        >
            <Typography variant="caption" sx={{ fontWeight: 500 }}>
                {absence.type === "absence"
                    ? `Absence${absence.justification ? " (Justifier)" : " (Non justifier)"}`
                    : `Congés${absence.justification ? " (Justifier)" : " (Non justifier)"}`}
            </Typography>
            <Typography sx={{ fontWeight: 500, fontSize: "0.7rem" }}>
                {absence.startHeure}:{absence.startMinute} - {absence.endHeure}:{absence.endMinute}
            </Typography>
        </AbsenceContainer>
    );
};
