import React from 'react';
import { Box, Typography, Stack, Grid } from '@mui/material';
import { pxToRem } from '@/shared/theme/typography';
import { faCalendarDay, faCalendarTimes, faHashtag, faUserTie } from '@fortawesome/free-solid-svg-icons';
import FontAwesome from '@/shared/components/fontawesome';
import RoadMapHistoryTable from './roadmap-history-table';
import { fr } from 'date-fns/locale';
import FormContainer from '@/layouts/form/form-container';

const data = {
  title: 'Feuille de route  novembre 2025',
  description: 'Feuille de route  novembre 2025',
  sender: 'Manuel Dupon',
  sendDate: '29 Septembre 2025',
  nbrDriver: '15',
  frequency: 'Quotidienne',
};
const RoadMapHistoryDetails = () => {
  return (
    <>
      <FormContainer isSousElemnt sx={{pt:0}}>
        <Typography
          sx={{
            textAlign: 'center',
            p: 3,
            fontSize: pxToRem(30),
            color: 'primary.main',
            fontWeight: (theme) => theme.typography.fontWeightBold,
          }}
        >
          {data.title}
        </Typography>
        <Stack direction="row" justifyContent="space-between" sx={{ px: 3 }}>
          <Stack spacing={1}>
            <Stack direction="row" alignItems="center" spacing={1}>
              <FontAwesome icon={faCalendarDay} color="primary.main" width={16} />
              <Typography>Date d&apos;envoie : {data.sendDate}</Typography>
            </Stack>
            <Stack direction="row" alignItems="center" spacing={1}>
              <FontAwesome icon={faUserTie} color="primary.main" width={16} />
              <Typography>Envoyer par : {data.sender}</Typography>
            </Stack>
          </Stack>

          <Stack spacing={1}>
            <Stack direction="row" alignItems="center" spacing={1}>
              <FontAwesome icon={faUserTie} color="primary.main" width={16} />
              <Typography>Nombre de chauffeurs : {data.nbrDriver}</Typography>
            </Stack>
            <Stack direction="row" alignItems="center" spacing={1}>
              <FontAwesome icon={faHashtag} color="primary.main" width={16} />
              <Typography>Description : {data.description}</Typography>
            </Stack>
          </Stack>
          <Stack spacing={1}>
            <Stack direction="row" alignItems="center" spacing={1}>
              <FontAwesome icon={faCalendarTimes} color="primary.main" width={16} />
              <Typography>Fréquence : {data.frequency}</Typography>
            </Stack>
           
          </Stack>
        </Stack>

        <RoadMapHistoryTable />
      </FormContainer>
    </>
  );
};

export default RoadMapHistoryDetails;
