// src/shared/sections/establishment/attendance/components/attendance-sheet-header.tsx

import React from 'react'
import { Box, Typography } from "@mui/material"
import { IAttendanceNotCher, IAttendanceSheetCher } from "@/shared/types/attendance-sheet"
import FontAwesome from "@/shared/components/fontawesome"
import { faBuilding, faRoute, faCalendarAlt } from "@fortawesome/free-solid-svg-icons"

interface AttendanceSheetHeaderProps {
  data: IAttendanceNotCher | IAttendanceSheetCher;
}

const AttendanceSheetHeader: React.FC<AttendanceSheetHeaderProps> = ({ data }) => {
  return (
    <Box 
      sx={{ 
        mb: 4, 
        p: 2, 
        bgcolor: 'grey.100', 
        borderRadius: 1,
        display: 'grid',
        gridTemplateColumns: 'repeat(3, 1fr)',
        gap: 2
      }}
    >
      <Box sx={{ display: 'flex', alignItems: 'center', gap: 1 }}>
        <FontAwesome icon={faBuilding} color="primary.main" width={16} />
        <Box>
          <Typography variant="subtitle2" sx={{  color: "primary.main", fontWeight: 600 }}>
            Département
          </Typography>
          <Typography variant="body1" fontWeight="medium">
            {data.departement || '-'}
          </Typography>
        </Box>
      </Box>
      
      <Box sx={{ display: 'flex', alignItems: 'center', gap: 1 }}>
        <FontAwesome icon={faRoute} color="primary.main" width={16} />
        <Box>
          <Typography variant="subtitle2" sx={{ color: 'primary.main', fontWeight: 600 }}>
            Circuit
          </Typography>
          <Typography variant="body1" fontWeight="medium">
            {data.circuit || '-'}
          </Typography>
        </Box>
      </Box>
      
      <Box sx={{ display: 'flex', alignItems: 'center', gap: 1 }}>
        <FontAwesome icon={faCalendarAlt} color="primary.main" width={16} />
        <Box>
          <Typography variant="subtitle2" sx={{ color: 'primary.main', fontWeight: 600 }}>
            Période
          </Typography>
          <Typography variant="body1" fontWeight="medium">
            {`${data.month} ${data.year}` || '-'}
          </Typography>
        </Box>
      </Box>
    </Box>
  );
};

export default AttendanceSheetHeader;