import { IMMATRICULATIONS } from "@/shared/_mock"
import { _CHAUFFEURS } from "@/shared/_mock/_absenceDriver"
import { _vehicles } from "@/shared/_mock/flottes/_vehicle"
import type { FormFieldType } from "@/shared/types/common"
import { type IFuelFee, FuelType } from "@/shared/types/flottes/fuelFee"
import {
  faHashtag,
  faCalendarDay,
  faRoad,
  faNoteSticky,
  faMoneyBill,
  faMoneyBills,
  faEur,
  faEuro,
  faLocation,
  faBuilding,
} from "@fortawesome/free-solid-svg-icons"

export const _FUEL_TYPE_OPTIONS = [
  { value: FuelType.Diesel, label: "Diesel" },
  { value: FuelType.Essence, label: "Essence" },
  { value: FuelType.Electrique, label: "Électrique" },
  { value: FuelType.Hybride, label: "Hybride" },
]

export const _INCLUDE_IN_FEES_OPTIONS = [
  { value: "oui", label: "Oui" },
  { value: "non", label: "Non" },
]

export const fuelFeeFormFields: FormFieldType<IFuelFee>[] = [
  {
    name: "vehicule",
    label: "Véhicule",
    type: "combobox",
    options: IMMATRICULATIONS.map((m) => ({ value: m, label: m })),
    placeholder: "Choisissez un véhicule",
  },
  {
    name: "chauffeur",
    label: "Chauffeur",
    type: "combobox",
    options: _CHAUFFEURS.map((chauffeur) => ({ value: chauffeur, label: chauffeur })),
    placeholder: "Choisissez un chauffeur",
  },
  {
    name: "date",
    label: "Date",
    type: "date",
    icon: faCalendarDay,
  },
  {
    name: "type",
    label: "Type",
    type: "select",
    options: _FUEL_TYPE_OPTIONS,
    placeholder: "Choisissez un type",
  },
  {
    name: "departement",
    label: "Département",
    type: "text",
    placeholder: "Entrez le département",
    icon: faBuilding,
  },
  {
    name: "kmCompteur",
    label: "Km Compteur",
    type: "text",
    placeholder: "00000",
    icon: faHashtag,
  },
  {
    name: "kmParcourue",
    label: "Kilomètre parcourus",
    type: "text",
    placeholder: "000",
    icon: faRoad,
  },
  {
    name: "volumeCarburant",
    label: "Volume carburant",
    type: "number",
    placeholder: "00",
    icon: faHashtag,
  },
  {
    name: "prix",
    label: "Prix",
    type: "number",
    placeholder: "000",
    icon: faEuro,
  },
  {
    name: "total",
    label: "Total",
    type: "number",
    placeholder: "0000",
    disabled: true,
    icon: faHashtag,
  },
  {
    name: "observation",
    label: "Observation",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon: faNoteSticky,
  },
]
