import { FormFieldType } from "@/shared/types/common";
import { Departements } from "@/shared/types/etablissement";
import { IMileage } from "@/shared/types/flottes/mileage";
import { faCar, faGasPump, faHashtag, faNoteSticky, faPhone, faUserTie } from "@fortawesome/free-solid-svg-icons";

export const mileageFormFields: FormFieldType<IMileage>[] = [
  {
    name: 'anormalKm',
    label: 'kilométrage anormale',
    type: 'text',
    placeholder: '0000 000 0000',
    icon: faHashtag
  },
  {
    name: 'firstname',
    label: 'Prenom',
    type: 'text',
    icon: faUserTie
  },
  {
    name: 'lastname',
    label: 'Nom',
    type: 'text',
    icon: faUserTie
  },
  {
    name: 'car',
    label: 'Voiture',
    type: 'text',
    icon: faCar
  },
  {
    name: 'petrolier',
    label: 'Pétrolier',
    type: 'text',
    icon: faGasPump
  },
  {
    name: 'telephone',
    label: 'Téléphone',
    type: 'text',
    placeholder: '+33 0 00 00 00 00',
    icon: faPhone
  },
  {
    name: 'startDate',
    label: 'Date début',
    type: 'date',
  },
  
  {
    name: 'endDate',
    label: 'Date Fin',
    type: 'date',
  },
  {
    name: 'department',
    label: 'Département',
    type: 'select',
    options: Object.entries(Departements).map(([value, label]) => ({
      label,
      value
    }))
  },
  {
    name: "observation",
    label: "Observation",
    type: "textarea",
    placeholder: "Ajoutez une note ou une observation",
    icon: faNoteSticky,
  },
]