import { useDroppable } from "@dnd-kit/core"
import { TableCell, Box, SxProps, Theme } from "@mui/material"
import { alpha } from "@mui/material/styles"
import type React from "react"

interface DroppableCellProps {
  driverId: string
  children: React.ReactNode
  height: number | string
  width?: number | string
  sx?: SxProps<Theme>
}

export function DroppableCell({
  driverId,
  children,
  height,
  width,
  sx,
}: DroppableCellProps) {
  const { setNodeRef, isOver } = useDroppable({
    id: driverId,
  })

  return (
    <TableCell
      ref={setNodeRef}
      tabIndex={-1}
      sx={{
        position: "relative",
        padding: 0,
        borderBottom: (theme) => `1px solid ${theme.palette.divider}`,
        borderLeft: (theme) => `1px solid ${theme.palette.divider}`,
        backgroundColor: (theme) => (isOver ? alpha(theme.palette.primary.main, 0.1) : "white"),
        "&:last-of-type": {
          borderRight: (theme) => `1px solid ${theme.palette.divider}`,
        },
        height,
        width,
        outline: "none",
        ...sx,
      }}
    >
      {children}
    </TableCell>
  )
}