import { FormFieldType } from '@/shared/types/common';
import { IDemandeAbsence } from '@/shared/types/leave';

export const absenceFormFields: FormFieldType<IDemandeAbsence>[] = [
  {
    name: 'requestType',
    label: 'Type de demande',
    type: 'select',
    required: true,
    options: [
      { value: 'Congé', label: 'Congé' },
      { value: 'Absence', label: 'Absence' }
    ]
  },
  {
    name: 'leaveType',
    label: 'Type de congé',
    type: 'select',
    required: true,
    options: [
      { value: 'LEAVE_PAID', label: 'Congé payé' },
      { value: 'LEAVE_UNPAID', label: 'Congé sans solde' },
      { value: 'LEAVE_SICK', label: 'Congé maladie' },
      { value: 'LEAVE_PARENTAL', label: 'Congé parental' },
      { value: 'LEAVE_RTT', label: 'RTT' },
      { value: 'OTHER', label: 'Autre' }
    ]
  },
  {
    name: 'absenceType',
    label: 'Type d\'absence',
    type: 'select',
    required: true,
    options: [
      { value: 'EXTERNAL_ASSIGNMENT', label: 'Mission externe' },
      { value: 'PROFESSIONAL_TRAINING', label: 'Formation professionnelle' },
      { value: 'EXCEPTIONAL_REMOTE_WORK', label: 'Télétravail exceptionnel' },
      { value: 'AUTHORIZED_ABSENCE', label: 'Absence autorisée' },
      { value: 'UNAUTHORIZED_ABSENCE', label: 'Absence non autorisée' },
      { value: 'MEDICAL_APPOINTMENT', label: 'Rendez-vous médical' },
      { value: 'OTHER', label: 'Autre' }
    ]
  },
  {
    name: 'startDate',
    label: 'Date de début',
    type: 'date',
    required: true
  },
  {
    name: 'endDate',
    label: 'Date de fin',
    type: 'date',
    required: true
  },
  {
    name: 'status',
    label: 'Statut',
    type: 'select',
    required: true,
    options: [
      { value: 'En attente', label: 'En attente' }
    ],
    disabled: true
  },
  {
    name: 'reason',
    label: 'Motif',
    type: 'text',
    required: true,
    multiline: true,
    rows: 4
  }
]; 