import * as Yup from "yup"

export const besoinRecrutementSchema = Yup.object({
  demandeur: Yup.string().required("Le demandeur est requis"),
  motif: Yup.string().required("Le motif est requis"),
  nombrePostes: Yup.number()
    .required("Le nombre de postes est requis")
    .min(1, "Le nombre de postes doit être supérieur à 0"),
  dateCreation: Yup.string().nullable(),
  dateTraitement: Yup.string().nullable(),
  statut: Yup.string().nullable(),
  candidatureAssocieeId: Yup.string().nullable(),
  description: Yup.string().nullable(),
  competencesRequises: Yup.string().nullable(),
  experienceRequise: Yup.string().nullable(),
  typeContrat: Yup.string().nullable(),
  departement: Yup.string().nullable(),
})
