import { IClient } from '@/shared/types/client'
import { Card, CardContent, Input, List, ListItem, ListItemIcon, ListItemText } from '@mui/material'
import { faSkype } from '@fortawesome/free-brands-svg-icons/faSkype'
import { faBirthdayCake } from '@fortawesome/free-solid-svg-icons'
import React, { FC } from 'react'
import FontAwesome from '@/shared/components/fontawesome'
import { Box } from '@mui/system'

interface SecondaryDetailsProps {
    client: IClient
}
const SecondaryDetails: FC<SecondaryDetailsProps> = ({ client }) => {
    const [skype, setSkype] = React.useState<string>('Ajouter un(e) skype')
    const [birthday, setBirthday] = React.useState<string>('Ajouter un(e) anniversaire')
    const [workBirthday, setWorkBirthday] = React.useState<string>('Ajouter un(e) anniversaire de travail')
    return (
        <Card sx={{ borderRadius: 1, display: 'flex', alignItems: 'row', justifyContent: 'space-between', height: '100%', width: "100%" }}>
            <CardContent>
                <List sx={{ display: 'flex', flexDirection: 'column' }}>
                    <ListItem sx={{ display: 'flex', flexDirection: 'column' }}>
                        <Box sx={{ display: 'flex', alignItems: 'center', width: '100%' }}>
                            <ListItemIcon>
                                <FontAwesome icon={faSkype} width={20} />
                            </ListItemIcon>
                            <ListItemText primary="Skype" />
                        </Box>
                        <Input sx={{ marginLeft: 7 }} value={skype} onChange={(e) => setSkype(e.target.value)} />
                    </ListItem>

                    <ListItem sx={{ display: 'flex', flexDirection: 'column' }}>
                        <Box sx={{ display: 'flex', alignItems: 'center', width: '100%' }}>
                            <ListItemIcon>
                                <FontAwesome icon={faBirthdayCake} width={20} />
                            </ListItemIcon>
                            <ListItemText primary="Anniversaire" />
                        </Box>
                        <Input sx={{ marginLeft: 7 }} value={birthday} onChange={(e) => setBirthday(e.target.value)} />
                    </ListItem>

                    <ListItem sx={{ display: 'flex', flexDirection: 'column' }}>
                        <Box sx={{ display: 'flex', alignItems: 'center', width: '100%' }}>
                            <ListItemIcon>
                                <FontAwesome icon={faBirthdayCake} width={20} />
                            </ListItemIcon>
                            <ListItemText primary="Skype" />
                        </Box>
                        <Input sx={{ marginLeft: 7 }} value={workBirthday} onChange={(e) => setWorkBirthday(e.target.value)} />
                    </ListItem>
                    {/* <ListItem>
                        <ListItemIcon>
                            <FontAwesome icon={faBirthdayCake} width={20} />
                        </ListItemIcon>
                        <ListItemText primary="Anniversaire" secondary="Ajouter un(e) anniversaire" />
                    </ListItem> */}
                    {/* <ListItem>
                        <ListItemIcon>
                            <FontAwesome icon={faBirthdayCake} width={20} />
                        </ListItemIcon>
                        <ListItemText primary="Anniversaire de travail" secondary="Ajouter un(e) anniversaire de travail" />
                    </ListItem> */}
                </List>
            </CardContent>
        </Card>
    )
}

export default SecondaryDetails
