import { JoursAttribues } from "./chauffeur";
import { Sens } from "./circuit";
import { AddressData } from "./common";
import { RouteMarker } from './Maps';

export enum TypeTrajet {
  personnalise = 'personnalise',
  Normal = 'normal',
}
export enum BinaryQuestion {
  Oui = 'oui',
  Non = 'non',
}
export enum EtatTrajet {
  NonControle = 'non_controle',
  Controle = 'controle',
  Modifier = 'modifie',
}
export enum TypeVehicule {
  Bus = 'bus',
  Berline = 'mini_bus',
  Abarth = 'abarth',
}
export interface TripPointDto {
  id?: string;
  tripId: string;
  title: string;
  address: string;
  usage: string;
  coordinates: {
    lat: number;
    lng: number;
  };
}
export type TrajetPageFilterParams = {
  id?: string;
  dateTrajet?: string; 
  jour?: string;
  sens?: 'DEPARTURE' | 'RETURN';
  rotation?: boolean;
  nbrUsagers?: number;
  nbrEtablissements?: number;
  tripState?: 'CONTROLE' | 'MODIFIE' | 'NON CONTROLE';
  driverName?: string;
  vehicleName?: string;
  hasTolls?: boolean;
  companyName?: string;
  clientName?: string;
  tripType?: 'NORMAL' | 'PERSONALIZED';
  sortBy?: string;
  sortDirection?: 'asc' | 'desc';
  page?: number;
  size?: number;
};
export interface ITrajet {
    id: string;
    dateDebut: string; 
    circuitAvenant?: string;
    intitule: string;
    sensAR: Sens;
    rotation?: BinaryQuestion;
    nombreUsagers?: number;
    nombreEtablissements?: number;
    etat: EtatTrajet;
    datePersonnalisation?:string;
    chauffeur?: string;
    vehicule?: string;
    jours?: JoursAttribues;
    peages?: BinaryQuestion;
    societe?: string;
    client?: string;
    typeTrajet?:TypeTrajet;
    observationPersonnalisation?:string;
    observationFeuilleRoute?:string;
    isActive?: boolean;
    origine?: string;
    destination?: string;
    distanceKm?: number;
    duree?: string;
    days?: string;
    dateTrip?: string;  
    statut?: string;
    etatConfirmation?: string;
    etatControle?: string;
    etatVehicule?: string;
    points?: RouteMarker[] ;
    tripState?: 'CONTROLE' | 'MODIFIE' | 'NON_CONTROLE';
    tripType?: 'NORMAL' | 'PERSONNALISE';
    sens?: 'DEPARTURE' | 'RETURN';
    hasTolls?: boolean;
    nbrUsagers?: number;
    nbrEtablissements?: number;
    origin?: string;
    duration?: string;
    customizationNote?: string;
    routeSheetNote?: string;
    customizedDate?: string;
    circuitId?: string;
    avenantDate?: string;
    vehicleName?: string;
}  
  export interface  ISuiviTrajet {
    id:string;
    tripId: string;
    nom: string;
    adresse: string;
    horaire: string;
    km: string;
    tps: string;
    gps: string;
    gps1: string;
    gps2: string;
    pointType?: PointType;
  }
  export enum PointType {
    ESTABLISHMENT = 'establishment',
    PASSENGER = 'passenger'
  }
  
  export interface TripPointResponse {
    id: string;
    tripId: string;
    sequenceOrder: number;
    label: string;
    passengerId: number;
    passengerName: string;
    address: {
      fullAddress: string;
      street: string;
      postalCode: string;
      city: string;
      country: string;
    };
    latitude: number;
    longitude: number;
    arrivalTime: string;
    departureTime: string;
    distanceFromPreviousPoint: number;
    timeFromPreviousPoint: number;
    isTemporaryForUser: boolean;
  }
  export interface IAddPoint {
    endPoint?: string;
    endPointAddress: AddressData;
    user?: string;
  }

export interface IAddPointRequest {
  tripId: string;
  sequenceOrder: number;
  label: string;
  passengerId?: number;
  passengerName?: string;
  address: AddressData;
  latitude: number;
  longitude: number;
  arrivalTime: string;
  departureTime: string;
  distanceFromPreviousPoint: number;
  timeFromPreviousPoint: number;
  isTemporaryForUser: boolean;
}


export interface IPassenger {
  id: number;
  name: string;
}


export const MOCK_PASSENGERS: IPassenger[] = [
  { id: 5001, name: 'Fatima El Houari' },
  { id: 5002, name: 'John Doe' },
  { id: 5003, name: 'Jane Smith' },
  { id: 5004, name: 'Alice Johnson' },
  { id: 5005, name: 'Bob Brown' },
  { id: 5006, name: 'Charlie Davis' },
  { id: 5007, name: 'Diana Evans' },
  { id: 5008, name: 'Ethan White' },
  { id: 5009, name: 'Fiona Green' },
  { id: 5010, name: 'George Black' },
  // ... other passengers
];
