import Box from '@mui/material/Box';
import Stack from '@mui/material/Stack';
import { SecondaryLogo } from '@/shared/components/logo';
import { BORDER, NAV } from '../config-layout';
import { useTheme, alpha } from '@mui/material/styles';
import NavToggleButton from '../common/nav-toggle-button';
import { usePathname } from 'next/navigation';
import { useNavData } from './config-navigation';
import { useMemo } from 'react';
import {  Typography } from '@mui/material';
import { noWrapStyles } from '@/shared/theme/css';
import { common } from '@/shared/theme/palette';
import CustomTooltip from '@/shared/components/tooltips/tooltip-custom';

// ----------------------------------------------------------------------

export default function NavMini() {
  const theme = useTheme();
  const {rootMenuList} = useNavData(25);
  const currentPath = usePathname();
  const currentMenuItem = useMemo(() => {
    return rootMenuList.find((item) => currentPath.startsWith(item.path));
  }, [rootMenuList, currentPath]);
  
  return (
    <Box
      sx={{
        width: NAV.W_MINI,
      }}
    >
      <NavToggleButton
        sx={{
          left: NAV.W_MINI - 12,
        }}
      />

      <Stack
        sx={{
          pb: 2,
          height: 1,
          position: 'fixed',
          width: NAV.W_MINI,
          borderRight: (theme) => `dashed 1px ${theme.palette.divider}`,
          color: 'text.white',
          bgcolor: common.white,
          borderRadius: BORDER.RADIUS_NAV,
        }}
      >
        <SecondaryLogo sx={{ mx: 'auto', my: 2 }} />

        {currentMenuItem && (
                <Box
                sx={{
                  display: 'flex',
                  flexDirection: 'column',
                  alignItems: 'center',
                  pt: 1,
                }}
              >
                <Box 
                component="span"
                sx={{
                  color : theme.palette.primary.main
                }}>
                  {currentMenuItem.icon}
                </Box>
                <CustomTooltip arrow title={currentMenuItem.title}  placement="right">

                <Typography
                  variant="caption"
                  sx={{
                    ...noWrapStyles,
                    textAlign: 'center',
                    px:1,
                    fontSize: 10,
                    fontWeight: theme.typography.fontWeightBold,
                    color : theme.palette.primary.main
                  }}
                >
                  {currentMenuItem.title}
                </Typography>
                </CustomTooltip>

              </Box>
        )}
      </Stack>
    </Box>
  );
}
