import type { TableColumn } from "../types/common"
import type { IClient } from "../types/client"
import { MOCK_ADDRESSES } from "."

export const _PORTAL_STATUS = [
  { value: "tad", label: "TAD" },
  { value: "client", label: "Client" },
]

export const _BILLING_TERMS = [
  { value: "mensuelle", label: "Mensuelle" },
  { value: "annuelle", label: "Annuelle" },
  { value: "trimestrielle", label: "Trimestrielle" },
]

export const _TYPE_CLIENT = [
  { value: "assurence", label: "syndicat transport" },
  { value: "carrosserie", label: "Carrosserie" },
  { value: "garage", label: "Garage" },
]
export const _TYPE_STRUCT = [
  { value: "departementDeLaDrome", label: "Departement De La Drome" },
  { value: "departementDeLaGironde", label: "Departement De La Gironde" },
  { value: "departementDeLaSarthe", label: "Departement De La Sarthe" },
  { value: "departementDeLaCorreze", label: "Departement De La Correze" },
]

export const _clients = [...Array(55)].map((_, index) => {
  const signatureDate = new Date(2020 + Math.floor(index / 12), index % 12, 15)
  const paymentDate = new Date(signatureDate)
  paymentDate.setDate(paymentDate.getDate() + 30)

  return {
    id: (index + 1).toString(),
    nomClient: ["Dubois SARL", "Martin & Cie", "Petit Industries", "Laurent Services", "Bernard Transport"][index % 5],
    type: _TYPE_CLIENT[index % 3].value,
    siret: `${(123456789 + index).toString().padStart(9, "0")}00014`,
    brancheMere: `BR-${(index + 1).toString().padStart(3, "0")}`,
    codeApe: ["4939A", "4931Z", "4939B", "4932Z", "4939C"][index % 5],
    observation: ["RAS", "Client prioritaire", "Contrat spécial", "Nouveau client", "Client historique"][index % 5],
    email: `contact${index + 1}@example.com`,
    telephone: `0${Math.floor(Math.random() * 9 + 1)}${(index + 100000000).toString().slice(-8)}`,
    telephoneMobile: `0${Math.floor(Math.random() * 9 + 1)}${(index + 100000000).toString().slice(-8)}`,
    banque: ["BNP", "Société Générale", "Crédit Agricole", "CIC", "Crédit Mutuel"][index % 5],
    iban: `FR${(76000000 + index).toString().padStart(8, "0")}`,
    dateSignature: signatureDate.toISOString().split("T")[0],
    compteComptable: `411${(100 + index).toString().padStart(3, "0")}`,
    compteAuxiliaire: `AUX${(100 + index).toString().padStart(3, "0")}`,
    compteVente: `706${(100 + index).toString().padStart(3, "0")}`,
    dateReglement: paymentDate.toISOString().split("T")[0],
    attributionPortail: _PORTAL_STATUS[index % 2].value,
    modalitesFacturation: _BILLING_TERMS[index % 3].value,
    adresse: MOCK_ADDRESSES[index % 4],
    isActive: Math.random() < 0.6,
    civilite: "",
    firstName: "",
    lastName: "",
    tva: "",
    colorCode: "",
    password: "",
  }
})

export const DEFAULT_CLIENT_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N° Client", type: "text", align: "left" },
  { id: "firstName", label: "Nom Client", type: "text", align: "left" },
  { id: "clientType", label: "Type de Client", type: "text", align: "center" },
  { id: "siret", label: "Siret", type: "text", align: "center" },
  { id: "mainBranch", label: "Branche mère", type: "text", align: "center" },
  { id: "apeCode", label: "Code APE", type: "text", align: "center" },
  { id: "observation", label: "Observation", type: "text", align: "center" },
  { id: "email", label: "Mail", type: "text", align: "center" },
  { id: "landlinePhone", label: "Téléphone fixe", type: "text", align: "center" },
  { id: "phoneNumber", label: "Téléphone mobile", type: "text", align: "center" },
  { id: "bankName", label: "Banque", type: "text", align: "center" },
  { id: "iban", label: "IBAN", type: "text", align: "center" },
  { id: "signatureDate", label: "Date signature", type: "date", align: "center" },
  { id: "accountingAccount", label: "Compte comptable", type: "text", align: "center" },
  { id: "auxiliaryAccount", label: "Compte auxiliaire", type: "text", align: "center" },
  { id: "salesAccount", label: "Compte de vente", type: "text", align: "center" },
  { id: "paymentDate", label: "Date de règlement", type: "date", align: "center" },
  { id: "portalAssignment", label: "Attribution d'un portail", type: "status", align: "center" },
  { id: 'userStatus', label: 'Active', type: 'boolean', align: 'center' },
  { id: "", label: "Action" },
];

export const INITIAL_CLIENT_DATA: IClient = {
  id: "",
  createdAt: "",
  updatedAt: "",
  lastName: "",
  firstName: "",
  email: "",
  birthDate: "",
  birthPlace: "",
  civility: undefined,
  phoneNumber: "",
  password: "",
  userStatus: undefined,
  photoUrl: "",
  isArchived: false,
  landlinePhone: "",
  mainBranch: undefined,
  portalAssignment: undefined,
  signatureDate: "",
  colorCode: "",
  siret: "",
  tva: "",
  agency_id: 0,
  apeCode: "",
  paymentDate: "",
  observation: "",
  bankName: "",
  iban: "",
  auxiliaryAccount: "",
  salesAccount: "",
  accountingAccount: "",
  accountHolder: "",
  accountAddress: "",
  swiftBic: "",
  clientType: undefined,
  addresses: [],
  mapAdresse: {
    address: '',
    lat: 0,
    lng: 0,
    city: '',
    postalCode: '',
    country: '',
    formattedAddress: ''
  },
  roles: []
};



export const getPortalStatus = (status: string): string => {
  const statusObj = _PORTAL_STATUS.find((s) => s.value === status)
  return statusObj ? statusObj.label : "Inconnu"
}

export const getBillingTerms = (terms: string): string => {
  const termsObj = _BILLING_TERMS.find((t) => t.value === terms)
  return termsObj ? termsObj.label : "Inconnu"
}

export const getTypeTerms = (terms: string): string => {
  const termsObj = _TYPE_STRUCT.find((t) => t.value === terms)
  return termsObj ? termsObj.label : "Inconnu"
}
