export const _CONTRACT_CIRCUITS = [...Array(10)].map((_, index) => {
    const isPrimary = index % 2 === 0;
    const circuitCode = isPrimary ? 'EC-001' : 'SC-002';
    const schoolType = isPrimary ? 'École Primaire' : 'Secondaire';
    const session = isPrimary ? 'Matin' : 'Soirée';
    
    const outboundTime = isPrimary ? '15:00 - 15:30' : '18:00 - 18:30';
    const returnTime = isPrimary ? '8:00 - 8:30' : '20:00 - 20:30';
    
    const outboundRoute = isPrimary 
      ? '(École → Domicile)' 
      : '(Domicile → Collège)';
    const returnRoute = isPrimary 
      ? '(Domicile → École)' 
      : '(Collège → Domicile)';
    
    const costPerTrip = isPrimary ? 20 : 25;
    
    return {
      id: (index + 1).toString().padStart(3, '0'),
      code: circuitCode,
      school: schoolType,
      session: session,
      time1: outboundTime,
      route1: outboundRoute,
      time2: returnTime,
      route2: returnRoute,
      cost1: `${costPerTrip} €`,
      cost2: `${costPerTrip} €`,
      total: `${costPerTrip * 2} €`,
    };
  });
  
  