import type { TableColumn } from "../types/common"
import { DriverRoadMapStatus, IActiveDriver, type IDriver } from "../types/driver"
import { _FUEL_TYPES } from "./flottes/_fuelFees";
import { _noms, _prenoms, FUEL_CARDS, generatePhoneNumber, INITIAL_ADDRESS, MOCK_ADDRESSES } from "."

export const _DRIVER_STATUS = [
  { value: "disponible", label: "Disponible" },
  { value: "absent", label: "Absent" },
];
export const _PERMIS_TYPE = [
  { value: "A", label: "A" },
  { value: "B", label: "B" },
  { value: "C", label: "C" },
  { value: "D", label: "D" },
];

export const DRIVER_STATUS_OPTIONS = [
  { value: DriverRoadMapStatus.Disponible, label: "Disponible" },
  { value: DriverRoadMapStatus.Affecte, label: "Affecté" },
  { value: DriverRoadMapStatus.Absent, label: "Absent" },
  { value: DriverRoadMapStatus.Suspendu, label: "Suspendu" },
  { value: DriverRoadMapStatus.NonDisponible, label: "Non disponible" },
]

export const VEHICLES = ["VSN89364", "KHT89364", "LMP74521", "WXY45678"]

export const _drivers: IActiveDriver[] = [...Array(25)].map((_, index) => {
 const id = index % _noms.length;
 const name = _noms[index % _noms.length];
 const departmentId = index % 5 + 1; 

  
  return {
    id: (index + 1),
   name,
   departmentId,
  }
})

export const DEFAULT_DRIVER_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N° chauffeur", type: "text",align: "center" },
  { id: "firstName", label: "Prénom", type: "text" },
  { id: "lastName", label: "Nom", type: "text" },
  { id: "vehicle", label: "Véhicule", type: "text" },
  { id: "fuelCard", label: "Carte carburant", type: "text" },
  { id: "fuelVolume", label: "Volume carburant", type: "text", align: "center" },
  { id: "phone", label: "Téléphone", type: "text" },
  { id: "email", label: "Email", type: "text" },
  { id: "departement", label: "departement", type: "text" },
  { id: "status", label: "Status", type: "text" },
  { id: "permis", label: "Permis", type: "text" },
  { id: "dateExpirationPermis", label: "Date d'expiration permis", type: "date" },
  { id: "titreCarteSejour", label: "Titre de carte de sejour", type: "text" },
  { id: "cni", label: "CNI", type: "text" },
  { id: "", label: "Action" },
]

export const INITIAL_DRIVER_DATA: IDriver = {
  id: "",
  civilite: "",
  dateOfBirth: "",
  firstName: "",
  lastName: "",
  vehicle: "",
  fuelCard:[],
  fuelVolume: "",
  phone: "",
  email: "",
  departement: "",
  status: DriverRoadMapStatus.Disponible,
  isActive: true,
  address:INITIAL_ADDRESS,
  permis: "",
  dateExpirationPermis: "",
  titreCarteSejour: "",
  cni: "",
  fuelType:[]
}

export const _DRIVER_CIRCUIT = [
  {
    id: 1,
    fullName: 'Alice Dupont',
    circuitCode: 'EC-001',
  },
  {
    id: 2,
    fullName: 'Bob Martin',
    circuitCode: 'SC-002',
  },
  {
    id: 3,
    fullName: 'Claire Bernard',
    circuitCode: 'EC-001',
  },
  {
    id: 4,
    fullName: 'David Morel',
    circuitCode: 'SC-002',
  },
];
