import type { TableColumn } from "@/shared/types/common";
import { EnvoiDeclaration, ITypeIncident, StatutSinistre, type IIncident } from "@/shared/types/flottes/incident";
import { _CHAUFFEURS } from "../_absenceDriver";
import { IMMATRICULATIONS } from "..";

export const _TYPES_SINISTRES = ["Accident", "Vol", "Dégâts matériels", "Vandalisme", "Dégâts naturels"];
export const _SINISTRE_OPTION_STATUT = [
    { label: "En cours", value: StatutSinistre.EnCours },
    { label: "Résolu", value: StatutSinistre.Resolu },
    { label: "En attente pièces", value: StatutSinistre.EnAttenteDePieces },
    { label: "En  réparation", value: StatutSinistre.Reparation },
];
export const ENVOI_DECLARATION_OPTIONS = [
  { label: "Mail", value: EnvoiDeclaration.MAIL },
  { label: "Courriel", value: EnvoiDeclaration.COURRIEL },
]

export const _incidents: IIncident[] = [...Array(30)].map((_, i) => {
  const idDossier = `${(i + 1).toString().padStart(6, "0")}`;
  const dateSinistre = new Date(2025, Math.floor(i / 6), 3 + (i % 28)).toISOString().split("T")[0];

  return {
    id: idDossier,
    driver:_CHAUFFEURS[i % _CHAUFFEURS.length],
    vehicule: IMMATRICULATIONS[i % IMMATRICULATIONS.length],
    typeSinistre: _TYPES_SINISTRES[i % _TYPES_SINISTRES.length],
    dateSinistre: dateSinistre,
    statut: _SINISTRE_OPTION_STATUT[i % 3].value,
    isActive: Math.random() < 0.8,
    envoiDeclaration: EnvoiDeclaration.COURRIEL,
    dateDeclaration: "",
    dateCloture: "",
    montantFranchise: 0,
    numeroDossier: "",
  };
});

export const DEFAULT_INCIDENT_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "driver", label: "Chauffeur", type: "text" },
  { id: "vehicule", label: "Véhicule", type: "text" },
  { id: "typeSinistre", label: "Type", type: "text" },
  { id: "dateSinistre", label: "Date", type: "date" },
  { id: "statut", label: "Statut", type: "statut" },
  { id: "isActive", label: "Actif", type: "boolean", align: "center" },
  { id: "", label: "Action" },
];

export const INITIAL_INCIDENT_DATA: IIncident = {
  id: "",
  vehicule: "",
  typeSinistre: "",
  driver: '',
  dateSinistre: "",
  statut: StatutSinistre.EnCours,
  constat:"non",
  envoiDeclaration:EnvoiDeclaration.COURRIEL,
  isActive: true,
  observation: "",
  dateDeclaration: "",
  dateCloture: "",
  montantFranchise: 0,
  numeroDossier: "",
};

export const _TypesIncidents: ITypeIncident[] = [...Array(30)].map((_, i) => {
  return {
    id: (i + 1).toString(),
    intitule:_TYPES_SINISTRES[i % _TYPES_SINISTRES.length],
    isActive: Math.random() < 0.8,
  };
});

export const DEFAULT_TYPE_INCIDENT_TABLE_HEAD: TableColumn[] = [
  { id: "id", label: "N°", type: "text" },
  { id: "intitule", label: "Type de sinistre", type: "text" },
  { id: "isActive", label: "Actif", type: "boolean", align: "center" },
  { id: "", label: "Action" },
];

export const INITIAL_TYPE_INCIDENT_DATA: ITypeIncident = {
  id: "",
  intitule:"",
  isActive: true,
};

