export type NotificationType = {
  id: string;
  title: string;
  description: string;
  type: 'automation' | 'mention' | 'assignment';
  link?: string;
  timestamp: string;
  read: boolean;
};

export const mockNotifications: NotificationType[] = [
  {
    id: '1',
    title: 'Automations',
    description: "Bonjour, Pensez à jeter un coup d'œil au tableau des dysfonctionnement d'aujourd'hui.",
    type: 'automation',
    link: 'https://adanev-team.monday.com/boards/5719294769',
    timestamp: '10h',
    read: false,
  },
  {
    id: '2',
    title: 'Automations',
    description: "Bonjour, Pensez à jeter un coup d'œil au tableau de suivi des détournements de véhicules.",
    type: 'automation',
    link: 'https://adanev-team.monday.com/boards/detournements',
    timestamp: '17h',
    read: false,
  },
  {
    id: '3',
    title: '@Marie vous a mentionné',
    description: "Pouvez-vous vérifier le planning de la semaine prochaine ?",
    type: 'mention',
    link: '/dashboard/exploitation/chauffeur/planning',
    timestamp: '1 jour',
    read: true,
  },
  {
    id: '4',
    title: 'Tâche attribuée',
    description: "Validation des congés de l'équipe maintenance",
    type: 'assignment',
    link: '/dashboard/maintenance/conges',
    timestamp: '2 jours',
    read: false,
  },
  {
    id: '5',
    title: 'Automations',
    description: 'Rapport hebdomadaire de maintenance disponible',
    type: 'automation',
    link: '/dashboard/maintenance/rapports',
    timestamp: '3 jours',
    read: true,
  }
];

export const getNotificationsByType = (type: 'all' | 'mention' | 'assignment') => {
  if (type === 'all') return mockNotifications;
  if (type === 'mention') return mockNotifications.filter(notif => notif.type === 'mention');
  return mockNotifications.filter(notif => notif.type === 'assignment');
};

export const getUnreadCount = () => {
  return mockNotifications.filter(notif => !notif.read).length;
}; 