const endpointPrefix = '/api/circuit';

export const circuitEndpoints = {
  circuit: {
    search: endpointPrefix + "/search",
    add: endpointPrefix + "/add",
    update: endpointPrefix + "/update",
    updateStatus: (id : string) => endpointPrefix + `/${id}/status`,
    toggleActive: (circuitCode : string) => endpointPrefix + `/${circuitCode}/toggle-active`,
    addPassengers: endpointPrefix + "/add-passengers",
    autocomplete: endpointPrefix + "/autocomplete",
    ammendment:{
      getPassengersOfCircuit: (circuitId: string) => endpointPrefix + `/amendment/passengers/${circuitId}`,
    },
    amendmentPassenger: {
      getAllAmendmentsPassenger: endpointPrefix + '/amendment-passenger/search-amendments',
      getAmendmentPassengerById: (id: string) => endpointPrefix + `/amendment-passenger/${id}`,
      updateAmendmentPassenger: (id: string) => endpointPrefix + `/amendment-passenger/update/${id}`,
      addAmendmentPassenger: endpointPrefix + '/amendment-passenger/add',
      getActiveOrFutureAmendmentsByPassengerId: endpointPrefix + '/amendment-passenger/active-or-future',
    },
    tripDriverAssignment: {
      add: endpointPrefix + "/trip-driver-assignments/add",
      update: (id: string) => endpointPrefix + `/trip-driver-assignments/update/${id}`,
    },
    trip: {
      generateTripsTemp: (circuitId: string) => endpointPrefix + `/trip/generate-trips-tmp/${circuitId}`,
    }
  },
};
