import { CollaboratorStatus } from "@/shared/types/client";
import { State } from "@/shared/types/passenger";

const endpointPrefix = '/api/user';

export const userEndpoints = {
  user: {
    getAllUsers: endpointPrefix + "/all",
    client: {
      addClient: endpointPrefix + '/client/add',
      getAllClients: endpointPrefix + '/client/search',
      toggleActiveClient: (id: string) => `${endpointPrefix}/client/${id}/active`,
      getClientById: (id: string) => `/client/${id}`,
      updateClient: endpointPrefix + '/client/update',
      exportClients: endpointPrefix + '/client/export',
    },
     collaborator: {
      add: endpointPrefix + '/collaborators/add',
      update: endpointPrefix + '/collaborators/update',
      toggleActive: (id: string | number) => endpointPrefix + `/collaborators/toggle-active/${id}`,
      search: endpointPrefix + '/collaborators/search',
      changeStatus: (id: string | number, status: CollaboratorStatus) =>
      endpointPrefix + `/collaborators/change-status?id=${id}&status=${status}`,
      exportFiltered:  endpointPrefix + '/collaborators/export', // POST
      downloadExport: (filePath: string) =>  endpointPrefix +
        `/collaborators/download?filePath=${encodeURIComponent(filePath)}`,
      getAllCollaborators: endpointPrefix + '/collaborators/all',
      withoutTeam: endpointPrefix + '/collaborators/without-team',
    },

    auth: {
      login: endpointPrefix + '/login',
      logout: endpointPrefix + '/logout',
      history: endpointPrefix + '/history',
    },
    clientType: {
      getAll: endpointPrefix + '/clientType/all',
    },
    Role: {
      getAllRoles: '/api/user/role/all',
      createRole: '/api/user/role/add',
      updateRole: (id: string | number) => `/api/user/role/update/${id}`,
      changeStatus: (id: string | number, status: 'ENABLED' | 'DISABLED') =>
        `/api/user/role/${id}/status?status=${status}`,
      getPermissionsByRoleName: (roleName: string) => `/api/user/role/${roleName}/permissions`,
    },
    passenger: {
      getAllPassengers: endpointPrefix + '/passenger/search',
      getPassengerById: (id: string) => endpointPrefix + `/passenger/${id}`,
      updatePassenger: endpointPrefix + '/passenger/update',
      addPassenger: endpointPrefix + '/passenger/add',
      toggleArchive: (id: string) => endpointPrefix + `/passenger/${id}/toggle-archive`,
      exportPassengers: endpointPrefix + '/passenger/export',
      getShortPassengers: endpointPrefix + '/passenger/search/short',
      getRepresentativesByPassengerId : (passengerId: string) => endpointPrefix + `/passenger/representative/by-passenger/${passengerId}`,
      updateStatus: (id : string, passengerState: State) => endpointPrefix + `/passenger/update-state?passengerId=${id}&newState=${passengerState}`,
    },
    team: {
      getAllTeams: endpointPrefix + "/teams/search",
      createTeam: endpointPrefix + "/teams/create",
      updateTeam: endpointPrefix + "/teams/update",
      duplicateTeam: endpointPrefix + "/teams/duplicate",
      getTeamById: (id: string) => `${endpointPrefix}/teams/${id}`,
      toggleStatus: (id: string) => `${endpointPrefix}/teams/${id}/toggle-status`,
      removeMember: (teamId: number, memberId: number) => 
        `${endpointPrefix}/teams/${teamId}/members/${memberId}/remove`,
      exportTeams: endpointPrefix + "/teams/export",
      findAllTeamIdAndName: endpointPrefix + '/teams/findAllTeamIdAndName',
    },
    
  },
};
