// src/store/storageStore.ts
import { create } from "zustand"
import axiosInstance from "@/utils/axios"
import { documentEndpoints } from "../../endpoints/document-service"

interface StorageQuota {
  usedStorageBytes: number
  storageQuotaBytes: number
  usedStorageFormatted: string
  storageQuotaFormatted: string
}

interface StorageStore {
  quota: StorageQuota | null
  loading: boolean
  error: string | null
  fetchStorageQuota: (ownerUuid:string) => Promise<void>
}

export const useStorageStore = create<StorageStore>((set) => ({
  quota: null,
  loading: false,
  error: null,

fetchStorageQuota: async (ownerUuid:string) => {
    set({ loading: true, error: null });
    try {
      const response = await axiosInstance.get<StorageQuota>(
        documentEndpoints.Storage.getQuotaInfo(ownerUuid) 
      );
      
      set({ 
        quota: response.data, 
        loading: false 
      });
    } catch (error: any) {
      console.error("Storage quota fetch error:", error);
      set({
        error: error.message || "Failed to fetch storage quota",
        loading: false,
        quota: null
      });
    }
  },
}))
