import { faMagnifyingGlass, faWheelchair } from "@fortawesome/free-solid-svg-icons"

const SVG_CACHE = new Map<string, string>()

const loadColoredSVG = async (type: string, color: string): Promise<string> => {
  try {
    const response = await fetch(`/assets/icons/maps/dynamic/${type}.svg`)
    const svgText = await response.text()
    return svgText.replace(/{{color}}/g, color)
  } catch (error) {
    return ""
  }
}


export const getColoredSVG = async (type: string, color: string): Promise<string> => {
  const cacheKey = `${type}-${color}`
  
  if (SVG_CACHE.has(cacheKey)) {
    return SVG_CACHE.get(cacheKey)!
  }

  const svgContent = await loadColoredSVG(type, color)
  const result = `data:image/svg+xml;charset=UTF-8,${encodeURIComponent(svgContent)}`
  
  SVG_CACHE.set(cacheKey, result)
  return result
}

export const DEFAULT_POPOVER_DATA = [
  { icon: faWheelchair, value: "Anna Leblanc" },
  { icon: "/assets/icons/form/ic_house.svg", value: "Ecrire ici l'adresse" },
  { icon: faMagnifyingGlass, value: "Ecrire ici les specifications" },
]

